/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.base.debug.DebugDumpServiceBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.support.SupportRequestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.html.EHTMLAttribute;
import org.conqat.lib.commons.html.EHTMLElement;
import org.conqat.lib.commons.html.HTMLWriter;

@Path(value="api/system/debug/thread-dump")
public class DebugThreadDumpService
extends ApiBase {
    static final String ENDPOINT = "thread-dump";

    @GET
    @Operation(description="Dumps the stack traces for all currently running threads.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String getAllThreadsDump() throws StorageException {
        return DebugDumpServiceBase.printToString((ConsumerWithException<PrintWriter, StorageException>)((ConsumerWithException)SupportRequestService::appendStackTracesOfAllThreads));
    }

    @GET
    @Operation(description="Dumps the stack traces for all currently running threads as HTML.", tags={"Debugging"})
    @Produces(value={"text/html"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String getAllThreadsDumpAsHtml() {
        StringWriter stringWriter = new StringWriter();
        HTMLWriter writer = new HTMLWriter(new PrintWriter(stringWriter));
        writer.setSuppressLineBreaks(true);
        writer.addHTML5Doctype();
        writer.openElement((Enum)EHTMLElement.HTML);
        writer.openElement((Enum)EHTMLElement.BODY);
        writer.openElement((Enum)EHTMLElement.PRE);
        SupportRequestService.appendStackTracesOfThreads(arg_0 -> ((HTMLWriter)writer).addRawString(arg_0), string -> {
            writer.addRawString(string);
            writer.addRawNewLine();
        }, thread -> true, thread -> DebugThreadDumpService.writeTaskNameWithLink(thread, writer));
        writer.closeElement((Enum)EHTMLElement.PRE);
        writer.closeElement((Enum)EHTMLElement.BODY);
        writer.closeElement((Enum)EHTMLElement.HTML);
        writer.close();
        return stringWriter.toString();
    }

    private static void writeTaskNameWithLink(Thread thread, HTMLWriter writer) {
        writer.openElement((Enum)EHTMLElement.A, new Object[]{EHTMLAttribute.HREF, "thread-dump/" + thread.getName()});
        writer.addText(thread.toString());
        writer.addText(" " + String.valueOf((Object)thread.getState()));
        writer.closeElement((Enum)EHTMLElement.A);
        writer.addRawNewLine();
    }

    @GET
    @Operation(description="Dumps the stack traces for a specific thread with the name specified as target in the URL.", tags={"Debugging"})
    @Path(value="{thread}")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String getThreadDump(@PathParam(value="thread") @Parameter(description="The name of the thread which is dumped.") String threadName) throws StorageException {
        return DebugDumpServiceBase.printToString((ConsumerWithException<PrintWriter, StorageException>)((ConsumerWithException)writer -> SupportRequestService.appendStackTracesOfThreads(writer, thread -> threadName.equals(thread.getName()))));
    }
}

