/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IStorageInfoCapability;

@Path(value="api/system/debug/storage")
public class StorageSystemDebugInfoService
extends ApiBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get storage system debug info", description="Provides debug information about the storage system", tags={"Debugging"})
    @Produces(value={"text/plain"})
    public String getStorageInfo() throws StorageException {
        Optional storageInfoCapability = this.serviceInfo.getIndexLayer().getRawStorageSystemProvider().getCapability(IStorageInfoCapability.class);
        if (storageInfoCapability.isEmpty()) {
            return "Info capability not supported by the storage system!";
        }
        return ((IStorageInfoCapability)storageInfoCapability.get()).getStorageInfo();
    }
}

