/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.health;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.license.License;
import com.teamscale.core.license.LicenseManager;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import com.teamscale.core.user.EUserActivityPeriods;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserLastActivityIndex;
import com.teamscale.index.usage_data.UsageDataCollector;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.monitoring.prometheus.PrometheusMetricsUtils;
import com.teamscale.service.system.ExecutionStatusService;
import com.teamscale.service.system.health.HealthMetricsUtils;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DurationUtils;

public enum ESystemHealthMetric {
    WORKERS("workers"){

        @Override
        public List<SystemHealthMetricEntry> reportMetrics(IndexLayer indexLayer) throws StorageException {
            ArrayList<SystemHealthMetricEntry> metrics = new ArrayList<SystemHealthMetricEntry>();
            metrics.add(new SystemHealthMetricEntry("count", HealthMetricsUtils.getWorkerCount(indexLayer)));
            metrics.add(new SystemHealthMetricEntry("load", HealthMetricsUtils.getWorkerLoad(indexLayer)));
            return metrics;
        }
    }
    ,
    USERS("users"){

        @Override
        public List<SystemHealthMetricEntry> reportMetrics(IndexLayer indexLayer) throws StorageException {
            int licensedUsers = 0;
            if (LicenseManager.getInstance().getLicense() != null) {
                licensedUsers = LicenseManager.getInstance().getLicense().getNumUsers();
            }
            ArrayList<SystemHealthMetricEntry> metrics = new ArrayList<SystemHealthMetricEntry>();
            metrics.add(new SystemHealthMetricEntry("licensed", licensedUsers));
            metrics.add(new SystemHealthMetricEntry("enabled", ((UserIndex)indexLayer.openGlobalIndex(UserIndex.class)).getEnabledUserCount()));
            List lastActivityTimestamps = ((UserLastActivityIndex)indexLayer.openGlobalIndex(UserLastActivityIndex.class)).getLastActivityTimestamps();
            metrics.add(new SystemHealthMetricEntry("active.last-5-minutes", UsageDataCollector.calculateActiveUsers((TemporalAmount)Duration.ofMinutes(5L), (List)lastActivityTimestamps)));
            metrics.add(new SystemHealthMetricEntry("active.last-day", UsageDataCollector.calculateActiveUsers((TemporalAmount)Period.ofDays(1), (List)lastActivityTimestamps)));
            metrics.add(new SystemHealthMetricEntry("active.last-month", UsageDataCollector.calculateActiveUsers((TemporalAmount)DurationUtils.ONE_MONTH, (List)lastActivityTimestamps)));
            metrics.add(new SystemHealthMetricEntry("active.last-quarter", UsageDataCollector.calculateActiveUsers((TemporalAmount)Period.ofDays(90), (List)lastActivityTimestamps)));
            metrics.add(new SystemHealthMetricEntry("active.last-180-days", UsageDataCollector.calculateActiveUsers((TemporalAmount)Period.ofDays(180), (List)lastActivityTimestamps)));
            metrics.add(new SystemHealthMetricEntry("active.last-year", UsageDataCollector.calculateActiveUsers((TemporalAmount)DurationUtils.ONE_YEAR, (List)lastActivityTimestamps)));
            return metrics;
        }
    }
    ,
    COMMITTERS("committers"){

        @Override
        public List<SystemHealthMetricEntry> reportMetrics(IndexLayer indexLayer) throws StorageException {
            UserLastActivityIndex index = (UserLastActivityIndex)indexLayer.openGlobalIndex(UserLastActivityIndex.class);
            ArrayList<SystemHealthMetricEntry> metrics = new ArrayList<SystemHealthMetricEntry>();
            metrics.add(new SystemHealthMetricEntry("last-day", index.getNumberOfCommitters(EUserActivityPeriods.LAST_DAY)));
            metrics.add(new SystemHealthMetricEntry("last-week", index.getNumberOfCommitters(EUserActivityPeriods.LAST_WEEK)));
            metrics.add(new SystemHealthMetricEntry("last-month", index.getNumberOfCommitters(EUserActivityPeriods.LAST_MONTH)));
            metrics.add(new SystemHealthMetricEntry("last-quarter", index.getNumberOfCommitters(EUserActivityPeriods.LAST_90DAYS)));
            metrics.add(new SystemHealthMetricEntry("last-180-days", index.getNumberOfCommitters(EUserActivityPeriods.LAST_180DAYS)));
            metrics.add(new SystemHealthMetricEntry("last-year", index.getNumberOfCommitters(EUserActivityPeriods.LAST_YEAR)));
            return metrics;
        }
    }
    ,
    PROJECTS("projects"){

        @Override
        public List<SystemHealthMetricEntry> reportMetrics(IndexLayer indexLayer) throws StorageException {
            int projectCount = ((ProjectIndex)indexLayer.openGlobalIndex(ProjectIndex.class)).getAllProjectInfos().size();
            return List.of(new SystemHealthMetricEntry("count", projectCount));
        }
    }
    ,
    VERSION("version"){

        @Override
        public List<SystemHealthMetricEntry> reportMetrics(IndexLayer indexLayer) {
            return List.of(new SystemHealthMetricEntry("", ETeamscaleVersion.CURRENT_VERSION.toMetric()));
        }
    }
    ,
    JOB_QUEUE_SIZE("job_queue_size"){

        @Override
        public List<SystemHealthMetricEntry> reportMetrics(IndexLayer indexLayer) throws StorageException {
            ProjectIndex projectIndex = indexLayer.openProjectIndex();
            ExecutionStatusService.JobQueueCountWithDelayedJobs jobQueueCountWithDelayedJobs = ExecutionStatusService.getJobQueueSize(indexLayer, projectIndex.getAllProjectInfos());
            ArrayList<SystemHealthMetricEntry> metrics = new ArrayList<SystemHealthMetricEntry>();
            metrics.add(new SystemHealthMetricEntry("all", jobQueueCountWithDelayedJobs.numberOfAllJobs()));
            metrics.add(new SystemHealthMetricEntry("delayed", jobQueueCountWithDelayedJobs.numberOfDelayedJobs()));
            return metrics;
        }
    }
    ,
    SCHEDULER_STATE("scheduler_state"){

        @Override
        public List<SystemHealthMetricEntry> reportMetrics(IndexLayer indexLayer) throws StorageException {
            WorkerIndex workerIndex = (WorkerIndex)indexLayer.openGlobalIndex(WorkerIndex.class);
            ProjectSchedulingFilter projectSchedulingFilter = workerIndex.getSchedulingFilterAccess().get();
            ProjectSchedulingFilter.ESchedulingMode schedulingMode = projectSchedulingFilter.getSchedulingMode();
            return List.of(new SystemHealthMetricEntry("", "The state of the scheduler. " + PrometheusMetricsUtils.createCommentForEnumConversion(ProjectSchedulingFilter.ESchedulingMode.class), schedulingMode.ordinal()));
        }
    }
    ,
    LICENSE("license"){

        @Override
        public List<SystemHealthMetricEntry> reportMetrics(IndexLayer indexLayer) {
            License license = LicenseManager.getInstance().getLicense();
            double daysLeft = license == null ? 0.0 : (double)license.daysLeft();
            return List.of(new SystemHealthMetricEntry("expires", daysLeft));
        }
    };

    private final String namePrefix;

    private ESystemHealthMetric(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public List<SystemHealthMetricEntry> reportMetrics(ITeamscaleServiceInfo serviceInfo) throws StorageException {
        return this.reportMetrics(serviceInfo.getIndexLayer());
    }

    public abstract List<SystemHealthMetricEntry> reportMetrics(IndexLayer var1) throws StorageException;

    public record SystemHealthMetricEntry(String name, String comment, double value) {
        SystemHealthMetricEntry(String name, double value) {
            this(name, "metrics for " + name.toLowerCase() + ": " + name, value);
        }
    }
}

