/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import java.util.Comparator;
import org.conqat.lib.commons.collections.CounterSet;
import org.jspecify.annotations.NonNull;

public class TgaSummary
implements Comparable<TgaSummary> {
    private static final Comparator<TgaSummary> TGA_SUMMARY_COMPARATOR = Comparator.comparingDouble(tgaSummary -> tgaSummary.testGapRatio).thenComparing(tgaSummary -> TgaAggregationUtils.calculateUntestedChangedMethodsRatio(tgaSummary.states)).thenComparing(tgaSummary -> TgaAggregationUtils.calculateUntestedAddedMethodsRatio(tgaSummary.states));
    private static final String TEST_GAP_RATIO_PROPERTY = "testGapRatio";
    private static final String NUMBER_OF_TEST_GAPS_PROPERTY = "numberOfTestGaps";
    @JsonProperty(value="testGapRatio")
    protected final double testGapRatio;
    @JsonProperty(value="numberOfTestGaps")
    protected final int numberOfTestGaps;
    @JsonProperty(value="assessmentType")
    private final ETgaAssessmentType assessmentType;
    @JsonProperty(value="states")
    private final CounterSet<ETestGapState> states;

    @JsonCreator
    public TgaSummary(@JsonProperty(value="assessmentType") ETgaAssessmentType assessmentType, @JsonProperty(value="states") CounterSet<ETestGapState> states) {
        this.assessmentType = assessmentType;
        this.states = states;
        this.testGapRatio = TgaAggregationUtils.calculateRatio((ETgaAssessmentType)assessmentType, states);
        this.numberOfTestGaps = TgaAggregationUtils.countTestGaps(states);
    }

    @Override
    public int compareTo(@NonNull TgaSummary o) {
        if (this.getTotalStates() == 0) {
            return -1;
        }
        if (o.getTotalStates() == 0) {
            return 1;
        }
        return TGA_SUMMARY_COMPARATOR.compare(this, o);
    }

    public int getTotalStates() {
        return this.states.getTotal();
    }

    public int getNumberOfTestGaps() {
        return this.numberOfTestGaps;
    }

    public double getTestGapRatio() {
        return this.testGapRatio;
    }

    public CounterSet<ETestGapState> getStates() {
        return this.states;
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }
}

