/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.badge;

import com.teamscale.service.badge.StaticBadgeUtils;
import com.teamscale.service.badge.velocity.BadgeCreator;
import com.teamscale.service.badge.velocity.BadgeData;
import java.awt.Color;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.color.ColorUtils;
import org.conqat.lib.commons.string.StringUtils;

public class TgaBadgeCreator {
    private final double ratio;
    private final int testedChurn;
    private final int untestedChange;
    private final int untestedAddition;
    private final String format;
    private final String request;
    private final String incompleteBuildText;

    public TgaBadgeCreator(double ratio, int testedChurn, int untestedChange, int untestedAddition, String format, String request) {
        this.ratio = ratio;
        this.testedChurn = testedChurn;
        this.untestedChange = untestedChange;
        this.untestedAddition = untestedAddition;
        this.format = format;
        this.request = request;
        this.incompleteBuildText = "";
    }

    public TgaBadgeCreator(double ratio, int testedChurn, int untestedChange, int untestedAddition, String format, String request, String incompleteBuildText) {
        this.ratio = ratio;
        this.testedChurn = testedChurn;
        this.untestedChange = untestedChange;
        this.untestedAddition = untestedAddition;
        this.format = format;
        this.request = request;
        this.incompleteBuildText = incompleteBuildText;
    }

    public byte[] createBadge() {
        String tooltip = "-tested changes: " + this.testedChurn + StringUtils.LINE_SEPARATOR + "-untested changes: " + this.untestedChange + StringUtils.LINE_SEPARATOR + "-untested additions: " + this.untestedAddition + StringUtils.LINE_SEPARATOR;
        BadgeData badgeData = new BadgeData();
        if ("assessment".equals(this.format)) {
            StaticBadgeUtils.appendBuildJobsSegment(badgeData, this.incompleteBuildText);
            int testGaps = this.untestedAddition + this.untestedChange;
            String title = testGaps + " Test Gap";
            if (testGaps != 1) {
                title = title + "s";
            }
            title = title + " (" + StringUtils.formatAsPercentage((Number)this.ratio) + ")";
            badgeData.appendTitle(title, this.request);
            return this.retrieveAssessmentTgaBadge(badgeData);
        }
        badgeData.appendTitle("Test Gap", this.request);
        badgeData.appendSegment(StringUtils.formatAsPercentage((Number)this.ratio), tooltip, ColorUtils.toHtmlString((Color)Color.GRAY));
        return StringUtils.stringToBytes((String)BadgeCreator.createBadge(badgeData));
    }

    private byte[] retrieveAssessmentTgaBadge(BadgeData badgeData) {
        CounterSet colorCounter = new CounterSet();
        colorCounter.inc((Object)ETrafficLightColor.GREEN, this.testedChurn);
        colorCounter.inc((Object)ETrafficLightColor.YELLOW, this.untestedChange);
        colorCounter.inc((Object)ETrafficLightColor.RED, this.untestedAddition);
        if (colorCounter.getTotal() == 0) {
            badgeData.appendSegment("No changes relevant for TGA", "BLACK");
        }
        TgaBadgeCreator.appendColoredBadgeSegment(badgeData, ETrafficLightColor.GREEN, "tested changes: ", (CounterSet<ETrafficLightColor>)colorCounter);
        TgaBadgeCreator.appendColoredBadgeSegment(badgeData, ETrafficLightColor.YELLOW, "untested changes: ", (CounterSet<ETrafficLightColor>)colorCounter);
        TgaBadgeCreator.appendColoredBadgeSegment(badgeData, ETrafficLightColor.RED, "untested additions: ", (CounterSet<ETrafficLightColor>)colorCounter);
        return StringUtils.stringToBytes((String)BadgeCreator.createBadge(badgeData));
    }

    private static void appendColoredBadgeSegment(BadgeData badgeData, ETrafficLightColor color, String textPrefix, CounterSet<ETrafficLightColor> colorCounter) {
        int colorCount = colorCounter.getValue((Object)color);
        badgeData.appendSegmentWithCustomWidth((double)colorCount / (double)colorCounter.getTotal(), textPrefix + colorCount, color.getHexValue());
    }
}

