/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.table;

import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import com.teamscale.service.testgap.TgaSummary;
import com.teamscale.service.testgap.table.ETgaFigureType;
import com.teamscale.service.testgap.table.ITgaValue;
import java.util.List;
import org.conqat.lib.commons.collections.CounterSet;

public class TgaAssessment
implements ITgaValue {
    private final TgaSummary tgaSummary;

    public TgaAssessment(ETgaAssessmentType assessmentType, CounterSet<ETestGapState> counts) {
        this.tgaSummary = new TgaSummary(assessmentType, counts);
    }

    @Override
    public TgaSummary getSerializableValue() {
        return this.tgaSummary;
    }

    @Override
    public ETgaFigureType getValueType() {
        return ETgaFigureType.TGA_SUMMARY;
    }

    public String toString() {
        return this.tgaSummary.toString();
    }

    public static TgaAssessment create(ETgaAssessmentType assessmentType, List<AssessedTgaData.AssessedMethodData> assessedMethods) {
        CounterSet stateCounter = TgaAggregationUtils.countStates(assessedMethods, (ETgaAssessmentType)assessmentType);
        return new TgaAssessment(assessmentType, (CounterSet<ETestGapState>)stateCounter);
    }
}

