/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.index.testimpact.TestMinimizationJobOptionsIndex;
import com.teamscale.index.testimpact.TestMinimizationJobRun;
import com.teamscale.index.testimpact.TestMinimizationJobsIndex;
import com.teamscale.index.utils.AsyncServiceJobRun;
import com.teamscale.service.testimpact.MinimizationProgressCallback;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DurationUtils;

class AsyncMinimizationProgressCallback
implements MinimizationProgressCallback {
    private static final Duration INTERRUPT_CHECK_INTERVAL = Duration.ofSeconds(5L);
    private static final Duration PROGRESS_REPORTING_INTERVAL = Duration.ofSeconds(5L);
    private static final Logger LOGGER = LogManager.getLogger();
    private final LinkedList<AsyncServiceJobRun.ProcessProgress> processStack = new LinkedList();
    private Instant lastInterruptCheckInStorage = Instant.now();
    private Instant lastProgressReporting = Instant.now();
    private final String jobId;
    private final TestMinimizationJobsIndex jobIndex;
    private final TestMinimizationJobOptionsIndex jobOptionsIndex;

    AsyncMinimizationProgressCallback(String jobId, TestMinimizationJobsIndex jobIndex, TestMinimizationJobOptionsIndex jobOptionsIndex) {
        this.jobId = jobId;
        this.jobIndex = jobIndex;
        this.jobOptionsIndex = jobOptionsIndex;
    }

    @Override
    public AsyncMinimizationProgressCallback processStarts(String processDescription) throws InterruptedException, StorageException {
        this.interruptIfCancelled();
        this.processStack.push(new AsyncServiceJobRun.ProcessProgress(processDescription, 0, 0));
        TestMinimizationJobRun job = this.loadCurrentJobAbortIfStopped();
        this.storeUpdatedJob(job.withDescription(processDescription).withProgressStack(this.processStack));
        return this;
    }

    @Override
    public void processDone() throws InterruptedException, StorageException {
        if (this.processStack.isEmpty()) {
            throw new IllegalStateException("Please call `processStarts` before `processDone`.");
        }
        this.processStack.pop();
        TestMinimizationJobRun job = this.loadCurrentJobAbortIfStopped();
        this.storeUpdatedJob(job.withProgressStack(this.processStack));
        this.interruptIfCancelled();
    }

    @Override
    public void setProcessMaxSteps(int maxSteps) throws InterruptedException, StorageException {
        if (this.processStack.isEmpty()) {
            throw new IllegalStateException("Please call `processStarts` before `processDone`.");
        }
        AsyncServiceJobRun.ProcessProgress process = this.processStack.peek();
        this.reportProgress(process.step(), maxSteps);
    }

    @Override
    public void reportProgress(int step, int maxSteps) throws InterruptedException, StorageException {
        if (this.processStack.isEmpty()) {
            throw new IllegalStateException("Please call `processStarts` before `reportProgress`.");
        }
        AsyncServiceJobRun.ProcessProgress process = this.processStack.pop();
        this.processStack.push(new AsyncServiceJobRun.ProcessProgress(process.processDescription(), step, maxSteps));
        if (DurationUtils.elapsed((Duration)PROGRESS_REPORTING_INTERVAL, (Instant)this.lastProgressReporting)) {
            this.lastProgressReporting = Instant.now();
            TestMinimizationJobRun job = this.loadCurrentJobAbortIfStopped();
            this.storeUpdatedJob(job.withProgressStack(this.processStack));
        }
    }

    @Override
    public void reportProgress(int step) throws InterruptedException, StorageException {
        if (this.processStack.isEmpty()) {
            throw new IllegalStateException("Please call `processStarts` before `processDone`.");
        }
        AsyncServiceJobRun.ProcessProgress process = this.processStack.peek();
        this.reportProgress(step, process.maxSteps());
    }

    @Override
    public void reportProgress() throws InterruptedException, StorageException {
        if (this.processStack.isEmpty()) {
            throw new IllegalStateException("Please call `processStarts` before `processDone`.");
        }
        AsyncServiceJobRun.ProcessProgress process = this.processStack.peek();
        this.reportProgress(process.step() + 1, process.maxSteps());
    }

    @Override
    public void reportFailure(String failureMessage) throws StorageException {
        TestMinimizationJobRun job = this.jobIndex.getJobWithId(this.jobId);
        if (job != null) {
            this.storeUpdatedJob(job.withJobStatus(AsyncServiceJobRun.EJobStatus.FAILED).withDescription(failureMessage).withProgressStack(Collections.emptyList()));
        }
    }

    @Override
    public void interruptIfCancelled() throws InterruptedException, StorageException {
        if (DurationUtils.elapsed((Duration)INTERRUPT_CHECK_INTERVAL, (Instant)this.lastInterruptCheckInStorage)) {
            this.lastInterruptCheckInStorage = Instant.now();
            this.checkJobStillExists();
        }
    }

    private TestMinimizationJobRun loadCurrentJobAbortIfStopped() throws InterruptedException, StorageException {
        TestMinimizationJobRun result = this.jobIndex.getJobWithId(this.jobId);
        if (result == null) {
            throw new InterruptedException("The job is no longer scheduled. Aborting.");
        }
        return result;
    }

    private void storeUpdatedJob(TestMinimizationJobRun jobRun) {
        try {
            this.jobIndex.setJob(jobRun.getId(), jobRun);
        }
        catch (StorageException e) {
            LOGGER.error("Failed storing updated job info", (Throwable)e);
        }
    }

    private void checkJobStillExists() throws InterruptedException, StorageException {
        if (this.jobOptionsIndex.getJobOptionsFor(this.jobId) == null) {
            throw new InterruptedException("The job is no longer scheduled. Aborting.");
        }
    }
}

