/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.testimpact.TestListDescriptor;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

public interface IStoredTestListsService {
    @GET
    @Operation(summary="Get stored test lists", description="Retrieves the list of available test list descriptors.", tags={"Test Intelligence"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<TestListDescriptor> getStoredTestLists() throws StorageException;

    @GET
    @Path(value="names")
    @Operation(summary="Get stored test lists names", description="Retrieves the list of available test list descriptors names.", tags={"Test Intelligence"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<String> getStoredTestListsNames() throws StorageException;

    @POST
    @Operation(summary="Save a given test list", description="Creates a test list descriptor in the system.", tags={"Test Intelligence"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_TEST_QUERIES})
    public void saveTestListDescriptor(@RequestBody(required=true) TestListDescriptor var1) throws StorageException;

    @DELETE
    @Path(value="{testListName}")
    @Operation(summary="Delete test list", description="Deletes a test list descriptor from the system.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="Pareto list with the given name could not be found.")})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_TEST_QUERIES})
    public void deleteTestListDescriptor(@Parameter(description="Name of the test list to delete") @PathParam(value="testListName") String var1) throws StorageException;
}

