/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.index.testimpact.MethodId;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.sourcecode.coverage.TestWithClusterId;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.SetMap;

public record TestPrioritizationData(Set<PrioritizableTest> selectedTests, Set<MethodId> methodsToTest, Map<String, TestWithClusterId> testsAvailableForExecution) {
    Set<PrioritizableTest> getSelectedTests() {
        return this.selectedTests;
    }

    Set<MethodId> getMethodsToTest() {
        return this.methodsToTest;
    }

    public SetMap<String, PrioritizableTest> getTestClustersById() {
        SetMap testsByClusterId = new SetMap();
        CCSMAssert.isTrue((this.testsAvailableForExecution != null ? 1 : 0) != 0, (String)"Can only cluster tests if available tests are provided in the request.");
        for (PrioritizableTest impactedTest : this.selectedTests) {
            TestWithClusterId testWithClusterId = this.testsAvailableForExecution.get(impactedTest.getUniformPathString());
            CCSMAssert.isNotNull((Object)testWithClusterId, (String)("Unexpectedly tried to cluster a test " + impactedTest.getUniformPathString() + " which is not part of the available tests."));
            testsByClusterId.add((Object)testWithClusterId.clusterId, (Object)impactedTest);
        }
        return testsByClusterId;
    }
}

