/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.information_retrieval.scoring;

import com.teamscale.index.tests.information_retrieval.data.Term;
import com.teamscale.service.testimpact.information_retrieval.ITfIdfGroundTruth;
import com.teamscale.service.testimpact.information_retrieval.scoring.IScoringOperator;
import java.util.LinkedHashMap;
import java.util.PriorityQueue;
import java.util.SequencedMap;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class ScoringOperatorBase
implements IScoringOperator {
    protected final ITfIdfGroundTruth groundTruth;
    protected final CounterSet<Term> changeRequestTerms;
    private final PriorityQueue<Pair<Term, Double>> topScoringTerms;
    private final int numTopContributingTermsToKeep;

    ScoringOperatorBase(ITfIdfGroundTruth groundTruth, CounterSet<Term> changeRequestTerms, int numTopContributingTermsToKeep) {
        this.groundTruth = groundTruth;
        this.numTopContributingTermsToKeep = numTopContributingTermsToKeep;
        this.changeRequestTerms = changeRequestTerms;
        this.topScoringTerms = new PriorityQueue(Math.max(1, numTopContributingTermsToKeep), (e1, e2) -> Double.compare((Double)e2.getSecond(), (Double)e1.getSecond()) * -1);
    }

    @Override
    public final double score(UniformPath uniformPath, CounterSet<Term> changeQueryTerms, CounterSet<Term> testImplementationTerms) throws StorageException {
        this.topScoringTerms.clear();
        return this.scoreTestImplementation(uniformPath, changeQueryTerms, testImplementationTerms);
    }

    @Override
    public SequencedMap<Term, Double> getTopContributingTerms() {
        LinkedHashMap<Term, Double> frequencies = new LinkedHashMap<Term, Double>();
        this.topScoringTerms.stream().limit(this.numTopContributingTermsToKeep).forEach(element -> frequencies.put((Term)element.getFirst(), (Double)element.getSecond()));
        return frequencies;
    }

    protected void storeTermContributions(Term term, double scoreContribution) {
        this.topScoringTerms.add((Pair<Term, Double>)Pair.createPair((Object)term, (Object)scoreContribution));
        if (this.topScoringTerms.size() > this.numTopContributingTermsToKeep) {
            this.topScoringTerms.poll();
        }
    }

    protected abstract double scoreTestImplementation(UniformPath var1, CounterSet<Term> var2, CounterSet<Term> var3) throws StorageException;
}

