/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.legacy;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.logging.UncriticalStatusCode;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.testimpact.TestMinimizationResult;
import com.teamscale.service.testimpact.TestMinimizationService;
import com.teamscale.service.testimpact.legacy.LegacyTestMinimizationRequestOptionsPre80;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/minimized-tests")
public class LegacyTestMinimizationService
extends ApiBase {
    @Context
    private ResourceContext resourceContext;

    @PublicApi(since=ETeamscaleVersion.VERSION_6_3_0, deprecatedSince=ETeamscaleVersion.VERSION_7_8_0)
    @UncriticalStatusCode(value=Response.Status.PRECONDITION_FAILED)
    @Operation(summary="Get minimized Test Set", description="Returns a list of test clusters that have been determined to be the best tests to run in the amount of time that was specified in the request. The clusters are formed according tothe clustering-regex that can be specified in the request options.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="412", description="The given commit has not been processed yet."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @GET
    public TestMinimizationResult getMinimizedTests(@BeanParam LegacyTestMinimizationRequestOptionsPre80 testMinimizationRequestOptions) throws StorageException, InterruptedException {
        return ((TestMinimizationService)this.resourceContext.getResource(TestMinimizationService.class)).getMinimizedTests(testMinimizationRequestOptions.toTestMinimizationRequestOptions());
    }
}

