/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization.strategies;

import com.teamscale.index.testimpact.MethodId;
import com.teamscale.service.testimpact.MinimizationProgressCallback;
import com.teamscale.service.testimpact.prioritization.ETestSelectionReason;
import com.teamscale.service.testimpact.prioritization.IPrioritizableTests;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import com.teamscale.service.testimpact.prioritization.PrioritizeUnderBudgetCallback;
import com.teamscale.service.testimpact.prioritization.preprocessing.LoadAllCoveredMethodsStep;
import com.teamscale.service.testimpact.prioritization.preprocessing.LoadTestDurationStep;
import com.teamscale.service.testimpact.prioritization.preprocessing.PreprocessingStepManager;
import com.teamscale.service.testimpact.prioritization.strategies.ERoundState;
import com.teamscale.service.testimpact.prioritization.strategies.RoundBasedTestPrioritizationStrategyBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;

public abstract class CoverageRoundBasedTestPrioritizationStrategyBase
extends RoundBasedTestPrioritizationStrategyBase {
    private Set<MethodId> methodsCoveredInRound;
    private Set<MethodId> methodsCoveredInTotal = new HashSet<MethodId>();

    protected CoverageRoundBasedTestPrioritizationStrategyBase(MinimizationProgressCallback progressCallback) {
        super(progressCallback);
    }

    @Override
    public void loadFurtherData(PreprocessingStepManager preprocessingStepManager, Set<PrioritizableTest> tests) throws StorageException {
        preprocessingStepManager.getStep(LoadAllCoveredMethodsStep.class).execute(tests);
        preprocessingStepManager.getStep(LoadTestDurationStep.class).execute(tests);
    }

    @Override
    public <T extends IPrioritizableTests> List<T> orderMultipleTests(Collection<T> relevantTests, Set<MethodId> methodsToTest, @Nullable Long maxTestSuiteRuntimeMs, PrioritizeUnderBudgetCallback<T> budgetCallback) throws InterruptedException, StorageException {
        relevantTests.forEach(test -> test.initAdditionallyCoveredMethods(methodsToTest));
        return super.orderMultipleTests(relevantTests, methodsToTest, maxTestSuiteRuntimeMs, budgetCallback);
    }

    @Override
    protected <T extends IPrioritizableTests> Set<T> filterAvailableTests(Set<T> availableTests, ERoundState roundState) {
        Set filteredTests = CollectionUtils.filterToSet(availableTests, (Predicate)ETestSelectionReason.containsAnyFilter((ETestSelectionReason)roundState.getRelevantTestSelectionReason()), LinkedHashSet::new);
        if (filteredTests.isEmpty() && roundState.isEndState()) {
            return availableTests;
        }
        return filteredTests;
    }

    @Override
    protected <T extends IPrioritizableTests> void updateTestInfosBeforePrioritizationRound(Set<T> availableTests, ERoundState roundState) {
        boolean testsCoveringChangesRemain;
        this.methodsCoveredInRound = new HashSet<MethodId>();
        if (roundState.isCoverageBasedPrioritizationRound() && (testsCoveringChangesRemain = availableTests.stream().anyMatch(ETestSelectionReason.containsAnyFilter((ETestSelectionReason)ETestSelectionReason.COVERS_CHANGES)))) {
            availableTests.forEach(IPrioritizableTests::resetCurrentAdditionallyCoveredMethods);
        }
        super.updateTestInfosBeforePrioritizationRound(availableTests, roundState);
    }

    @Override
    protected <T extends IPrioritizableTests> void updateTestInfosAfterTestSelection(Set<T> availableTests, T selectedTest, ERoundState roundState) {
        ArrayList<MethodId> newlyCoveredMethods = new ArrayList<MethodId>();
        for (MethodId coveredMethod : selectedTest.getCoveredChangedMethods()) {
            if (this.methodsCoveredInRound.add(coveredMethod)) {
                newlyCoveredMethods.add(coveredMethod);
            }
            if (!this.methodsCoveredInTotal.add(coveredMethod)) continue;
            selectedTest.incrementNumberOfAdditionallyCoveredMethods();
        }
        for (IPrioritizableTests test : availableTests) {
            test.removeFromCurrentAdditionallyCoveredMethods(newlyCoveredMethods);
        }
        super.updateTestInfosAfterTestSelection(availableTests, selectedTest, roundState);
    }

    @Override
    protected <T extends IPrioritizableTests> boolean shouldAbortPrioritizationRound(Set<T> availableTests, ERoundState roundState) {
        if (!roundState.isCoverageBasedPrioritizationRound()) {
            return false;
        }
        boolean anyAdditionallyCoverable = availableTests.stream().anyMatch(t -> t.getNumberOfCurrentAdditionallyCoveredMethods() > 0L);
        if (!anyAdditionallyCoverable && roundState == ERoundState.ROUND_COVER_CHANGES_TO_EXHAUSTION) {
            availableTests.forEach(IPrioritizableTests::resetCurrentAdditionallyCoveredMethods);
        }
        return !anyAdditionallyCoverable && roundState == ERoundState.ROUND_COVER_CHANGES_ONCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPrioritizableTests> List<T> orderTests(Collection<T> relevantTests, Set<MethodId> methodsToTest, @Nullable Long maxTestSuiteRuntimeMs) throws InterruptedException, StorageException {
        Set<MethodId> savedMethodsCoveredInRound = this.methodsCoveredInRound;
        Set<MethodId> savedMethodsCoveredInTotal = this.methodsCoveredInTotal;
        try {
            this.methodsCoveredInRound = new HashSet<MethodId>();
            this.methodsCoveredInTotal = new HashSet<MethodId>();
            List<T> list = super.orderTests(relevantTests, methodsToTest, maxTestSuiteRuntimeMs);
            return list;
        }
        finally {
            this.methodsCoveredInRound = savedMethodsCoveredInRound;
            this.methodsCoveredInTotal = savedMethodsCoveredInTotal;
        }
    }
}

