/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.testimpact.CodeToTestPathsMapIndex;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.testimpact.TestImplementationIndex;
import com.teamscale.index.tests.PartitionAndTestExecutionResult;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestImplementationPathToExecutionPathIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/code/{uniformPath}/tests")
public class TestPathService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get test information for a file.", description="Returns a list of test locations and their execution results for a file.", tags={"Tests"}, responses={@ApiResponse(responseCode="204", description="The requested uniformPath does not exist or test case extraction is disabled.")})
    public List<TestPathExecutionWrapper> getTestPathsAndExecResults(@PathParam(value="uniformPath") @Parameter(description="The path to a file for which we collect test information from.") @ResolveToCodePath UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        if (!uniformPath.isCodePath()) {
            return new ArrayList<TestPathExecutionWrapper>();
        }
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        CodeToTestPathsMapIndex codeToTestPathsMapIndex = this.openProjectIndex(CodeToTestPathsMapIndex.class, historyOption);
        Set testImplementationPaths = codeToTestPathsMapIndex.getTestPaths(uniformPath.toString());
        if (testImplementationPaths == null) {
            return null;
        }
        ArrayList<String> testImplementationPathsList = new ArrayList<String>(testImplementationPaths);
        TestImplementationIndex testImplementationIndex = this.openProjectIndex(TestImplementationIndex.class, historyOption);
        List testImplementationForUniformPaths = testImplementationIndex.getTestImplementations(testImplementationPathsList);
        Map pathToImplementationsMap = CollectionUtils.zipAsMap(testImplementationPathsList, (SequencedCollection)testImplementationForUniformPaths);
        TestImplementationPathToExecutionPathIndex implementationToExecutionIndex = this.openProjectIndex(TestImplementationPathToExecutionPathIndex.class, historyOption);
        List executionPaths = implementationToExecutionIndex.getExecutionPathsForImplementationPaths(testImplementationPathsList);
        TestExecutionIndex testExecutionIndex = this.openProjectIndex(TestExecutionIndex.class, historyOption);
        SetMap pathToExecResultMap = testExecutionIndex.getTestExecutionsFromAllPartitions(executionPaths);
        return TestPathService.calculateTestPathsAndExecResults(testImplementationPathsList, executionPaths, pathToImplementationsMap, (SetMap<String, PartitionAndTestExecutionResult>)pathToExecResultMap);
    }

    private static List<TestPathExecutionWrapper> calculateTestPathsAndExecResults(List<String> testImplementationPaths, List<HashSet<String>> executionPaths, Map<String, TestImplementation> pathToImplementationsMap, SetMap<String, PartitionAndTestExecutionResult> pathToExecResultMap) {
        ArrayList<TestPathExecutionWrapper> result = new ArrayList<TestPathExecutionWrapper>();
        HashSet<Integer> usedLinesHashSet = new HashSet<Integer>();
        for (int i = 0; i < testImplementationPaths.size(); ++i) {
            String testImplementation = testImplementationPaths.get(i);
            TextRegionLocation location = pathToImplementationsMap.get(testImplementation).getLocation();
            int startLine = location.getRawStartLine() - 1;
            if (usedLinesHashSet.contains(startLine)) continue;
            usedLinesHashSet.add(startLine);
            ArrayList<PartitionAndTestExecutionResult> executionResults = new ArrayList<PartitionAndTestExecutionResult>();
            HashSet<String> testExecutionPaths = executionPaths.get(i);
            if (testExecutionPaths != null) {
                for (String executionPath : testExecutionPaths) {
                    executionResults.addAll(pathToExecResultMap.getCollectionOrEmpty((Object)executionPath));
                }
            }
            executionResults.sort(Comparator.comparing(executionResult -> executionResult.result().ordinal(), Comparator.reverseOrder()));
            result.add(new TestPathExecutionWrapper(testImplementation, executionResults, startLine));
        }
        return result;
    }

    public static final class TestPathExecutionWrapper {
        private static final String PATH_TO_TEST_PROPERTY = "testPath";
        private static final String TEST_EXECUTION_RESULTS_PROPERTY = "testExecutionResults";
        private static final String LINE_PROPERTY = "startLine";
        @JsonProperty(value="testPath")
        private final String testPath;
        @JsonProperty(value="testExecutionResults")
        private final List<PartitionAndTestExecutionResult> testExecutionResults;
        @JsonProperty(value="startLine")
        private final int startLine;

        @JsonCreator
        private TestPathExecutionWrapper(@JsonProperty(value="testPath") String path, @JsonProperty(value="testExecutionResults") List<PartitionAndTestExecutionResult> testExecutionResults, @JsonProperty(value="startLine") int line) {
            this.testExecutionResults = testExecutionResults;
            this.testPath = path;
            this.startLine = line;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public String getTestPath() {
            return this.testPath;
        }
    }
}

