/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tests.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Map;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

@Path(value="api/projects/{project}/tests/debug/dump-test-execution-index")
public class DebugDumpTestExecutionIndexService
extends ApiBase {
    @GET
    @Operation(tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String dumpTestExecutionIndex(@QueryParam(value="t") @Parameter(required=true) UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        StringBuilder outputBuilder = new StringBuilder();
        TestExecutionIndex testExecutionIndex = this.openProjectIndex(TestExecutionIndex.class, historyAccessOption);
        Map allTestExecutions = testExecutionIndex.getAllTestExecutions();
        allTestExecutions.forEach((key, testExecutionWithPartition) -> outputBuilder.append((String)key).append(" => ").append(testExecutionWithPartition).append("\n"));
        return outputBuilder.toString();
    }
}

