/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.treemap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfoContainer;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodIssueIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.treemap.TreeMapNodeBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.issues.IssueContributor;
import com.teamscale.service.metrics.treemap.TreemapServiceBase;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import com.teamscale.service.treemap.EStatisticsCalculation;
import com.teamscale.service.treemap.IColorOption;
import com.teamscale.service.treemap.IMetricOption;
import com.teamscale.service.treemap.MethodBasedTreeMapNodeBase;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.treemap.ITreeMapNode;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/methods/treemap")
public class MethodBasedTreemapService
extends TreemapServiceBase {
    @GET
    @Operation(summary="Get method-based treemap", description="Builds a treemap based on methods.", tags={"Treemap"})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, IssueContributor.IssuesLastUpdatedContributor.class})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public MethodBasedTreemapWrapper getMethodBasedTreemap(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @BeanParam FileParameters fileParameters, @BeanParam IssueQueryParameters issueQueryParameters, @Parameter(description="The metric option to use.", required=true, schema=@Schema(implementation=IMetricOption.class)) @QueryParam(value="metric") JsonNode metricOption, @Parameter(description="The coloring strategy to use.", required=true, schema=@Schema(implementation=IColorOption.class)) @QueryParam(value="coloring") JsonNode colorOption, @Parameter(description="Specifies how the statistics information displayed in the subtitle should be calculated.", required=true) @QueryParam(value="statistics-calculation") EStatisticsCalculation statisticsCalculation, @Parameter(description="The context for the statistics calculation", required=true, schema=@Schema(implementation=EStatisticsCalculation.StatisticsCalculationContext.class)) @QueryParam(value="statistics-calculation-context") JsonNode statisticsCalculationContext) throws StorageException, TreeMapBuilderException, ExecutionException, InterruptedException {
        CommitDescriptor resolvedCommit = this.resolve(commit);
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)resolvedCommit);
        Set<TeamscaleIssueId> queryIssues = this.getIssueIds(issueQueryParameters, historyAccessOption);
        IMetricOption<?> parsedOption = IMetricOption.fromJson(metricOption);
        parsedOption.init(this.serviceInfo.getPrimaryPublicId(), this.getIndexLayer(), (ProjectStorageSystem)this.getProjectStorageSystem(), resolvedCommit);
        Set<UniformPath> uniformPaths = parsedOption.filterPaths(this.getAllUniformPaths(fileParameters, historyAccessOption));
        TreemapBuilder treemapBuilder = new TreemapBuilder((ProjectStorageSystem)this.getProjectStorageSystem(), resolvedCommit, issueQueryParameters, parsedOption, colorOption, statisticsCalculation, EStatisticsCalculation.StatisticsCalculationContext.fromJson(statisticsCalculationContext), this.getParallelTaskExecutor());
        Object rootNode = treemapBuilder.calculateTreemap(fileParameters.getUniformPath(), uniformPaths, queryIssues);
        return new MethodBasedTreemapWrapper((MethodBasedTreeMapNodeBase)((Object)rootNode), treemapBuilder.getAverageStatisticsPerMethod(), treemapBuilder.getAverageStatisticsPerIssueReferencedMethod());
    }

    private Set<UniformPath> getAllUniformPaths(FileParameters fileParameters, HistoryAccessOption historyAccessOption) throws StorageException {
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)fileParameters.getUniformPath().getType(), null, (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser());
        return metricRetrievalStrategy.getMetricDirectoryEntries(List.of(fileParameters.getUniformPath().toString()), historyAccessOption).stream().map(MetricDirectoryEntry::getUniformPath).filter(fileParameters.matchFile()).map(UniformPathCompatibilityUtil::convert).collect(Collectors.toSet());
    }

    private Set<TeamscaleIssueId> getIssueIds(IssueQueryParameters parameters, HistoryAccessOption historyAccess) throws StorageException, TreeMapBuilderException {
        if (!parameters.shouldLoadIssues()) {
            return Collections.emptySet();
        }
        WorkItemHistoryIndexAggregation indexAggregation = WorkItemHistoryIndexAggregation.forIssues((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccess);
        try {
            return new HashSet<TeamscaleIssueId>(QueryableEntityUtils.runIssueQuery((IKeyedObjectIndex)indexAggregation, (String)parameters.getQuery(), (QueryableEntityUtils.QueryContext)QueryableEntityUtils.QueryContext.ofTimestamp((ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem(), (User)this.serviceInfo.getUser(), (StoredQueryIndex.EStoredQueryType)StoredQueryIndex.EStoredQueryType.ISSUE, (HistoryAccessOption)historyAccess)));
        }
        catch (QueryCompilationException | QueryParsingException e) {
            throw new TreeMapBuilderException("Error in issue query", e);
        }
    }

    public static final class IssueQueryParameters {
        @Parameter(description="Whether issues should be loaded and referenced to methods.")
        @QueryParam(value="should-load-issues")
        @DefaultValue(value="false")
        private boolean loadIssues;
        @Parameter(description="The query to use for loading issues. May be empty, to denote that all known issues should be loaded.")
        @QueryParam(value="query")
        @DefaultValue(value="")
        private String query;
        @Parameter(description="Regular expression describing additional branches for which issue references should be loaded.")
        @QueryParam(value="additional-branches")
        private Pattern additionalBranches;
        @Parameter(description="Specifies the minimum number of issue references. Methods with fewer issue references will be treated as if they would not have any reference at all.\n")
        @QueryParam(value="min-reference-count")
        @DefaultValue(value="1")
        private int minReferenceCount;
        @Parameter(description="Whether methods, which aren't referenced by enough issues loaded by `query`, should be excluded from the result treemap altogether.")
        @QueryParam(value="exclude-non-referenced")
        @DefaultValue(value="false")
        private boolean excludeNonReferencedMethods;
        @Parameter(description="The treemap node color to use for methods, which are not referenced by enough issues loaded by the provided `query` (in case they are not excluded).")
        @QueryParam(value="non-referenced-methods-color")
        @DefaultValue(value="#cccccc")
        private Color nonReferencedMethodsColor;

        public boolean shouldLoadIssues() {
            return this.loadIssues;
        }

        public String getQuery() {
            return this.query;
        }

        public Optional<Pattern> getAdditionalBranchesPattern() {
            return Optional.ofNullable(this.additionalBranches).filter(pattern -> !pattern.pattern().isEmpty());
        }

        public int getMinReferenceCount() {
            return this.minReferenceCount;
        }

        public boolean isExcludeNonReferencedMethods() {
            return this.excludeNonReferencedMethods;
        }

        public Color getNonReferencedMethodsColor() {
            return this.nonReferencedMethodsColor;
        }

        public String toString() {
            return "IssueQueryParameters[loadIssues=%s, query='%s', additionalBranches=%s, minReferenceCount=%d, excludeNonReferencedMethods=%s, nonReferencedMethodsColor=%s]".formatted(this.loadIssues, this.query, this.additionalBranches, this.minReferenceCount, this.excludeNonReferencedMethods, this.nonReferencedMethodsColor);
        }
    }

    public static final class FileParameters {
        @Parameter(description="Uniform path to build a treemap for", required=true, allowEmptyValue=true)
        @QueryParam(value="uniform-path")
        private UniformPath uniformPath;
        @Parameter(description="Regular expressions the individual file paths must match to be displayed.")
        @QueryParam(value="included-files-regexes")
        private List<Pattern> includedFilePatterns;
        @Parameter(description="Regular expressions the individual file paths must not match to be displayed.")
        @QueryParam(value="excluded-files-regexes")
        private List<Pattern> excludedFilePatterns;

        public Predicate<String> includeFile() {
            return this.includedFilePatterns.stream().filter(Objects::nonNull).map(Pattern::asMatchPredicate).reduce(Predicate::or).orElse(ignored -> true);
        }

        public Predicate<String> excludeFile() {
            return this.excludedFilePatterns.stream().filter(Objects::nonNull).map(Pattern::asMatchPredicate).reduce(Predicate::or).orElse(ignored -> false);
        }

        public Predicate<String> matchFile() {
            return this.includeFile().and(this.excludeFile().negate());
        }

        public UniformPath getUniformPath() {
            return this.uniformPath;
        }

        public String toString() {
            return "FileParameters[uniformPath=%s, includedFilePatterns=%s, excludedFilePatterns=%s]".formatted(this.uniformPath, this.includedFilePatterns, this.excludedFilePatterns);
        }
    }

    private static class TreemapBuilder<NODE extends MethodBasedTreeMapNodeBase> {
        private final IssueQueryParameters issueQueryParameters;
        private final IMetricOption<NODE> metricOption;
        private final IColorOption<NODE> colorOption;
        private final IParallelTaskExecutor parallelTaskExecutor;
        private final String mainBranch;
        private final Map<String, MethodIssueIndex> methodIssueIndexByBranch = new HashMap<String, MethodIssueIndex>();
        private final Map<String, MethodInfoIndex> methodInfoIndexByBranch = new HashMap<String, MethodInfoIndex>();
        private final EStatisticsCalculation.IStatisticsCalculator methodStatistics;
        private final EStatisticsCalculation.IStatisticsCalculator issueReferencedMethodStatistics;

        public TreemapBuilder(ProjectStorageSystem projectStorageSystem, CommitDescriptor commit, IssueQueryParameters issueQueryParameters, IMetricOption<NODE> metricOption, JsonNode colorOption, EStatisticsCalculation statisticsCalculation, EStatisticsCalculation.StatisticsCalculationContext statisticsCalculationContext, IParallelTaskExecutor parallelTaskExecutor) throws StorageException {
            this.issueQueryParameters = issueQueryParameters;
            this.colorOption = metricOption.parseColorOption(colorOption);
            this.metricOption = metricOption;
            this.parallelTaskExecutor = parallelTaskExecutor;
            this.mainBranch = commit.getBranchName();
            this.methodStatistics = statisticsCalculation.createStatisticsCalculator(statisticsCalculationContext);
            this.issueReferencedMethodStatistics = statisticsCalculation.createStatisticsCalculator(statisticsCalculationContext);
            Set<String> branches = TreemapBuilder.getBranches(projectStorageSystem, issueQueryParameters, commit.getBranchName());
            for (String branch : branches) {
                HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)new CommitDescriptor(branch, commit.getTimestamp()));
                this.methodIssueIndexByBranch.put(branch, (MethodIssueIndex)projectStorageSystem.openProjectIndex(MethodIssueIndex.class, historyAccessOption));
                this.methodInfoIndexByBranch.put(branch, (MethodInfoIndex)projectStorageSystem.openProjectIndex(MethodInfoIndex.class, historyAccessOption));
            }
        }

        private static Set<String> getBranches(ProjectStorageSystem projectStorageSystem, IssueQueryParameters issueQueryParameters, String defaultBranch) throws StorageException {
            Optional<Pattern> additionalBranchesPattern = issueQueryParameters.getAdditionalBranchesPattern();
            if (additionalBranchesPattern.isEmpty()) {
                return Set.of(defaultBranch);
            }
            return Stream.concat(Stream.of(defaultBranch), ((ProjectRepositoryChangeIndex)projectStorageSystem.openProjectIndex(ProjectRepositoryChangeIndex.class, null)).getRepositoryStatus().getNonPrecommitBranchNames().stream().filter(additionalBranchesPattern.get().asMatchPredicate())).collect(Collectors.toSet());
        }

        public NODE calculateTreemap(UniformPath rootPath, Set<UniformPath> childPaths, Set<TeamscaleIssueId> queriedIssues) throws ExecutionException, InterruptedException {
            NODE root = this.metricOption.createIntermediateNode(rootPath.toString());
            this.parallelTaskExecutor.processInParallelBatches(new ArrayList<UniformPath>(childPaths), batch -> this.calculateTreemapBatch(root, (List<UniformPath>)batch, queriedIssues), 100);
            return this.postProcessTreemap(root);
        }

        private void calculateTreemapBatch(NODE rootNode, List<UniformPath> childPathsBatch, Set<TeamscaleIssueId> queriedIssues) throws StorageException {
            Map<UniformPath, Set<AssociatedMethodInfo>> methods = this.loadMethods(this.mainBranch, childPathsBatch);
            for (UniformPath filePath : childPathsBatch) {
                Set<AssociatedMethodInfo> methodInfos = methods.getOrDefault(filePath, Collections.emptySet());
                if (methodInfos.isEmpty()) continue;
                Map<AssociatedMethodInfo, Set<TeamscaleIssueId>> issueReferences = this.getIssueReferences(methodInfos);
                this.metricOption.prepareForPath(filePath);
                for (AssociatedMethodInfo methodInfo : methodInfos) {
                    this.addMethodNode(rootNode, filePath, methodInfo, queriedIssues, issueReferences);
                }
                this.metricOption.finishPath(filePath);
            }
        }

        private Map<AssociatedMethodInfo, Set<TeamscaleIssueId>> getIssueReferences(Set<AssociatedMethodInfo> methodInfos) throws StorageException {
            if (!this.issueQueryParameters.shouldLoadIssues()) {
                return Collections.emptyMap();
            }
            HashMap<AssociatedMethodInfo, Set<TeamscaleIssueId>> result = new HashMap<AssociatedMethodInfo, Set<TeamscaleIssueId>>(this.getReferencesForLocations(this.mainBranch, methodInfos));
            this.augmentWithIssueReferencesFromOtherBranches(methodInfos, result);
            return result;
        }

        private void augmentWithIssueReferencesFromOtherBranches(Set<AssociatedMethodInfo> allMethodInfos, Map<AssociatedMethodInfo, Set<TeamscaleIssueId>> into) throws StorageException {
            if (this.methodIssueIndexByBranch.size() < 2) {
                return;
            }
            Map referencedIssuesByMethodName = into.entrySet().stream().collect(Collectors.groupingBy(entry -> ((AssociatedMethodInfo)entry.getKey()).getMethodName(), Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
            List<UniformPath> uniformPaths = allMethodInfos.stream().map(AssociatedMethodInfo::getUniformPath).distinct().toList();
            for (String branch : this.methodIssueIndexByBranch.keySet()) {
                if (this.mainBranch.equals(branch)) continue;
                Set<AssociatedMethodInfo> branchMethodInfos = this.loadMethods(branch, uniformPaths).values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                this.getReferencesForLocations(branch, branchMethodInfos).forEach((method, issues) -> referencedIssuesByMethodName.getOrDefault(method.getMethodName(), Collections.emptyList()).forEach(methodIssueReferences -> methodIssueReferences.addAll(issues)));
            }
        }

        private Map<AssociatedMethodInfo, Set<TeamscaleIssueId>> getReferencesForLocations(String branch, Set<AssociatedMethodInfo> methodInfos) throws StorageException {
            Map locationToMethodInfo = methodInfos.stream().collect(Collectors.toMap(AssociatedMethodInfo::getLocation, Function.identity()));
            Map mappingsForLocations = this.methodIssueIndexByBranch.get(branch).getMappingsForLocations(new ArrayList<MethodLocation>(locationToMethodInfo.keySet()));
            return mappingsForLocations.entrySet().stream().collect(Collectors.toMap(entry -> (AssociatedMethodInfo)locationToMethodInfo.get(entry.getKey()), entry -> new HashSet(((Map)entry.getValue()).keySet())));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addMethodNode(NODE root, UniformPath filePath, AssociatedMethodInfo methodInfo, Set<TeamscaleIssueId> queriedIssues, Map<AssociatedMethodInfo, Set<TeamscaleIssueId>> issueReferences) {
            TreeMapNodeBase fileNode;
            Set<TeamscaleIssueId> methodIssues = this.getMethodIssues(methodInfo, queriedIssues, issueReferences);
            if (this.issueQueryParameters.shouldLoadIssues() && this.issueQueryParameters.isExcludeNonReferencedMethods() && methodIssues.isEmpty()) {
                return;
            }
            NODE node = this.metricOption.createLeafNode(filePath, methodInfo, methodIssues);
            TreeMapNodeBase treeMapNodeBase = fileNode = root.getOrCreateChild(filePath.toString(), this.metricOption::createIntermediateNode);
            synchronized (treeMapNodeBase) {
                fileNode.addChild(node);
            }
            this.updateStatistics(node);
        }

        private synchronized void updateStatistics(NODE methodNode) {
            this.colorOption.updateStatistics(methodNode, this.getColoringContext());
            this.methodStatistics.updateStatistics((MethodBasedTreeMapNodeBase)((Object)methodNode));
            if (this.hasMatchingIssueCount((MethodBasedTreeMapNodeBase)((Object)methodNode))) {
                this.issueReferencedMethodStatistics.updateStatistics((MethodBasedTreeMapNodeBase)((Object)methodNode));
            }
        }

        private boolean hasMatchingIssueCount(MethodBasedTreeMapNodeBase methodNode) {
            return methodNode.getNumberOfMatchingIssues() >= this.issueQueryParameters.getMinReferenceCount();
        }

        private Set<TeamscaleIssueId> getMethodIssues(AssociatedMethodInfo methodInfo, Set<TeamscaleIssueId> queriedIssues, Map<AssociatedMethodInfo, Set<TeamscaleIssueId>> issueReferences) {
            if (!this.issueQueryParameters.shouldLoadIssues()) {
                return Collections.emptySet();
            }
            HashSet<TeamscaleIssueId> methodIssues = new HashSet<TeamscaleIssueId>(issueReferences.getOrDefault(methodInfo, Collections.emptySet()));
            methodIssues.retainAll(queriedIssues);
            return methodIssues;
        }

        private NODE postProcessTreemap(NODE root) {
            TreemapBuilder.aggregateValues(root);
            this.colorTreemap(root);
            root.recalculateAreaAggregates();
            return root;
        }

        private void colorTreemap(NODE node) {
            this.colorNode(node);
            for (ITreeMapNode child : node.getChildren()) {
                this.colorTreemap((MethodBasedTreeMapNodeBase)child);
            }
        }

        private void colorNode(NODE node) {
            Color color = this.determineColor(node);
            String colorMetricValue = this.colorOption.getColorMetricValue(node, this.getColoringContext());
            ((MethodBasedTreeMapNodeBase)((Object)node)).setColor(color, colorMetricValue);
        }

        private Color determineColor(NODE node) {
            if (this.issueQueryParameters.shouldLoadIssues() && !this.hasMatchingIssueCount((MethodBasedTreeMapNodeBase)((Object)node))) {
                return this.issueQueryParameters.getNonReferencedMethodsColor();
            }
            return this.colorOption.determineColor(node, this.getColoringContext());
        }

        private static void aggregateValues(MethodBasedTreeMapNodeBase node) {
            if (node.getChildren().isEmpty()) {
                return;
            }
            for (ITreeMapNode child : node.getChildren()) {
                TreemapBuilder.aggregateValues((MethodBasedTreeMapNodeBase)child);
            }
            node.aggregateValues();
        }

        private IColorOption.TreemapContext getColoringContext() {
            return new IColorOption.TreemapContext(this.issueQueryParameters.shouldLoadIssues(), this.issueQueryParameters.getMinReferenceCount());
        }

        private Map<UniformPath, Set<AssociatedMethodInfo>> loadMethods(String branch, List<UniformPath> filePaths) throws StorageException {
            HashMap<UniformPath, Set<AssociatedMethodInfo>> result = HashMap.newHashMap(filePaths.size());
            List<UniformPath> resolvedPaths = filePaths.stream().map(UniformPath::resolveToCodePath).toList();
            MethodInfoIndex index = this.methodInfoIndexByBranch.get(branch);
            List containers = index.getMethodContainersWithoutCrossAnnotationInfo(resolvedPaths);
            for (Pair pair : CollectionUtils.zip(filePaths, (Iterable)containers)) {
                MethodInfoContainer methodInfoContainer = (MethodInfoContainer)pair.getSecond();
                if (methodInfoContainer == null) continue;
                UniformPath path = (UniformPath)pair.getFirst();
                Set allMethodInfos = methodInfoContainer.getAllMethodInfos(path.resolveToCodePath());
                result.put(path, allMethodInfos);
            }
            return result;
        }

        public double getAverageStatisticsPerMethod() {
            return this.methodStatistics.getAverage();
        }

        public @Nullable Double getAverageStatisticsPerIssueReferencedMethod() {
            if (!this.issueQueryParameters.shouldLoadIssues()) {
                return null;
            }
            return this.issueReferencedMethodStatistics.getAverage();
        }
    }

    public record MethodBasedTreemapWrapper(@JsonProperty(value="rootNode") @Schema(description="The treemap root node") MethodBasedTreeMapNodeBase rootNode, @JsonProperty(value="statisticsAverage") @Schema(description="The average statistics calculation for all methods (even the ones not referenced by enough issues, if not excluded)") double statisticsAverage, @JsonProperty(value="statisticsAverageForIssueReferenced") @Schema(description="The average statistics calculation for methods referenced by an issue. `null` if no issues are loaded.") @Nullable Double statisticsAverageForIssueReferenced) {
    }
}

