/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.usage_info;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.usage_data.UsageDataCollector;
import com.teamscale.index.usage_data.UsageDataReportingOption;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/usage-data/preview")
public class UsageDataPreviewService
extends ApiBase {
    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Preview of usage data", description="Returns a preview of the data we collect if you opt-in to provide that data.", tags={"System"})
    public UsageDataPreview getUsageDataPreview(@RequestBody UsageDataReportingOption option) throws StorageException, JsonSerializationException {
        String content = new UsageDataCollector(this.serviceInfo.getIndexLayer()).collect(option);
        return new UsageDataPreview(JsonUtils.prettyPrintJSON((String)content));
    }

    public static class UsageDataPreview {
        @JsonProperty(value="targetUrl")
        private final String targetUrl = "https://usage.teamscale.com/";
        @JsonProperty(value="content")
        private final String content;

        private UsageDataPreview(String content) {
            this.content = content;
        }
    }
}

