/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.version;

import com.teamscale.commons.ServiceApiInfo;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.options.AdminContactUrlOption;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.version.Version;

@Path(value="api/version")
public class TeamscaleVersionApiInfoService
extends ApiBase {
    @GET
    @Operation(summary="Get API version", description="Returns information about the service API.", tags={"API"})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_8_0)
    @RequiresNoLogin
    public ServiceApiInfo getApiVersion() throws StorageException {
        String adminContactUrl = null;
        ServerOptionIndex serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        AdminContactUrlOption option = (AdminContactUrlOption)ServerOptionRegistry.getInstance().getServerOption("admin.contact.url", AdminContactUrlOption.class, serverOptionIndex);
        if (option != null && !StringUtils.isEmpty((String)option.url)) {
            adminContactUrl = option.url;
        }
        Version current = ETeamscaleVersion.CURRENT_VERSION.toVersionObject();
        Version minSupported = ETeamscaleVersion.MIN_SUPPORTED_API_VERSION.toVersionObject();
        if (EFeatureToggle.DISABLE_VERSION_DISPLAY.isEnabled() && !this.getPermissions().mayViewSystemStatus()) {
            current = new Version(current.getMajor(), current.getMinor(), 0);
            minSupported = new Version(minSupported.getMajor(), minSupported.getMinor(), 0);
        }
        return new ServiceApiInfo(current, minSupported, adminContactUrl);
    }
}

