/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook.github.event_handler;

import com.teamscale.core.authenticate.github.dto.Installation;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.service.webhook.github.data.InstallationRepositoryEventPayload;
import com.teamscale.service.webhook.github.event_handler.GitHubWebhookEventHandlerBase;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.intellij.lang.annotations.Language;

class GitHubRepositoriesInstallationEventHandler
extends GitHubWebhookEventHandlerBase {
    GitHubRepositoriesInstallationEventHandler(IndexLayer indexLayer) {
        super(indexLayer);
    }

    @Override
    public void handle(@Language(value="JSON") String eventPayload) throws StorageException, JsonSerializationException {
        InstallationRepositoryEventPayload installationRepositoryPayload = (InstallationRepositoryEventPayload)JsonUtils.deserializeFromJsonWithNullCheck((String)eventPayload, InstallationRepositoryEventPayload.class);
        GitHubInstallationIndex installationIndex = (GitHubInstallationIndex)this.indexLayer.openGlobalIndex(GitHubInstallationIndex.class);
        Installation installation = installationRepositoryPayload.installation();
        switch (installationRepositoryPayload.action()) {
            case "added": {
                installationIndex.addRepositoriesToInstallation(installation.getId(), installationRepositoryPayload.getAddedRepositoriesFullNames());
                break;
            }
            case "removed": {
                installationIndex.removeRepositoriesFromInstallation(installation.getId(), installationRepositoryPayload.getRemovedRepositoriesFullNames());
                break;
            }
        }
    }
}

