/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.logging;

import com.teamscale.commons.TeamscaleInstallationUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Order;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.json.JsonConfigurationFactory;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.yaml.YamlConfiguration;
import org.apache.logging.log4j.core.config.yaml.YamlConfigurationFactory;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@Plugin(name="TeamscaleLoggingConfigurationFactory", category="ConfigurationFactory")
@Order(value=10)
public class TeamscaleLoggingConfigurationFactory
extends ConfigurationFactory {
    private static final String LOG4J_2_CONFIG_FILE = "log4j2.yaml";
    public static final String TS_LOGGING_ENV_VARIABLE_NAME = "TS_LOGGING_CONF";

    public String[] getSupportedTypes() {
        return new String[]{"*"};
    }

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return TeamscaleLoggingConfigurationFactory.createConfiguration(loggerContext);
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation, ClassLoader loader) {
        return TeamscaleLoggingConfigurationFactory.createConfiguration(loggerContext);
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        return TeamscaleLoggingConfigurationFactory.createConfiguration(loggerContext);
    }

    static AbstractConfiguration getConfiguration() {
        return TeamscaleLoggingConfigurationFactory.createConfiguration(LoggerContext.getContext((boolean)false));
    }

    public static boolean configurationSupportsCustomLogs() {
        Configuration configuration = LoggerContext.getContext((boolean)false).getConfiguration();
        return TeamscaleLoggingConfigurationFactory.configurationSupportsCustomLogs(configuration);
    }

    @VisibleForTesting
    static boolean configurationSupportsCustomLogs(Configuration configuration) {
        return TeamscaleLoggingConfigurationFactory.isLevelConfiguredForEveryAppenderOrAppenderRef(configuration);
    }

    private static boolean isLevelConfiguredForEveryAppenderOrAppenderRef(Configuration configuration) {
        Set<String> appendersWithoutThresholdFilter = TeamscaleLoggingConfigurationFactory.getAppenderWithoutThresholdFilter(configuration);
        return configuration.getLoggers().values().stream().map(LoggerConfig::getAppenderRefs).flatMap(Collection::stream).filter(ref -> appendersWithoutThresholdFilter.contains(ref.getRef())).allMatch(ref -> ref.getLevel() != null);
    }

    private static Set<String> getAppenderWithoutThresholdFilter(Configuration configuration) {
        return configuration.getAppenders().values().stream().filter(appender -> !TeamscaleLoggingConfigurationFactory.hasThresholdFilter(appender)).map(Appender::getName).collect(Collectors.toSet());
    }

    private static boolean hasThresholdFilter(Appender appender) {
        if (appender instanceof AbstractAppender) {
            AbstractAppender actualAppender = (AbstractAppender)appender;
            Filter filter = actualAppender.getFilter();
            return TeamscaleLoggingConfigurationFactory.containsThresholdFilter(filter);
        }
        return false;
    }

    private static boolean containsThresholdFilter(@Nullable Filter filter) {
        if (filter == null) {
            return false;
        }
        String filterClassName = filter.getClass().getName();
        if (filterClassName.contains("ThresholdFilter")) {
            return true;
        }
        if (filter instanceof CompositeFilter) {
            CompositeFilter compositeFilter = (CompositeFilter)filter;
            for (Filter childFilter : compositeFilter.getFiltersArray()) {
                if (!TeamscaleLoggingConfigurationFactory.containsThresholdFilter(childFilter)) continue;
                return true;
            }
        }
        return false;
    }

    private static AbstractConfiguration createConfiguration(LoggerContext loggerContext) {
        String loggingEnvironment = System.getenv(TS_LOGGING_ENV_VARIABLE_NAME);
        if (loggingEnvironment != null) {
            return TeamscaleLoggingConfigurationFactory.configureWithLoggingEnvironment(loggerContext, loggingEnvironment);
        }
        Optional loggingConfigFile = TeamscaleInstallationUtils.locateConfigFile((String)LOG4J_2_CONFIG_FILE);
        if (loggingConfigFile.isPresent()) {
            return TeamscaleLoggingConfigurationFactory.configureWithConfigFile(loggerContext, (File)loggingConfigFile.get());
        }
        return TeamscaleLoggingConfigurationFactory.configureDefaultConsoleLog();
    }

    private static AbstractConfiguration configureWithLoggingEnvironment(LoggerContext loggerContext, String loggingEnvironment) {
        YamlConfiguration yamlConfiguration;
        block8: {
            String replacedLoggingEnvironment = loggingEnvironment.replaceAll("\\\\n", "\n");
            InputStream inputStream = StringUtils.toInputStream((String)replacedLoggingEnvironment);
            try {
                yamlConfiguration = new YamlConfiguration(loggerContext, new ConfigurationSource(inputStream));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Unexpected IO error while working in memory: {}", (Object)e.getMessage(), (Object)e);
                    System.exit(-1);
                    return null;
                }
            }
            inputStream.close();
        }
        return yamlConfiguration;
    }

    @VisibleForTesting
    static AbstractConfiguration configureWithConfigFile(LoggerContext loggerContext, File loggingConfigFile) {
        String filePath = loggingConfigFile.getAbsolutePath();
        File configFile = new File(filePath);
        String configFileName = configFile.getName().toLowerCase();
        ConfigurationFactory configurationFactory = TeamscaleLoggingConfigurationFactory.getConfigurationFactory(configFileName);
        return (AbstractConfiguration)configurationFactory.getConfiguration(loggerContext, TeamscaleLoggingConfigurationFactory.createConfigSource(configFile));
    }

    private static ConfigurationFactory getConfigurationFactory(String configFileName) {
        if (configFileName.endsWith(".yml") || configFileName.endsWith(".yaml")) {
            return new YamlConfigurationFactory();
        }
        if (configFileName.endsWith(".json")) {
            return new JsonConfigurationFactory();
        }
        return ConfigurationFactory.getInstance();
    }

    private static BuiltConfiguration configureDefaultConsoleLog() {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setConfigurationName("TeamscaleConsole");
        builder.setStatusLevel(Level.ERROR);
        String consoleAppenderRef = "stdout";
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender(consoleAppenderRef, "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
        appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "* %-5level [%threadName] %date:%variablesNotEmpty{ %mdc{job,trigger,project,commit}:} %message%n"));
        builder.add(appenderBuilder);
        builder.add((RootLoggerComponentBuilder)((RootLoggerComponentBuilder)builder.newRootLogger(Level.INFO).add(builder.newAppenderRef(consoleAppenderRef))).addAttribute("level", Level.INFO));
        return (BuiltConfiguration)builder.build();
    }

    private static ConfigurationSource createConfigSource(File configFile) {
        try {
            return new ConfigurationSource((InputStream)new FileInputStream(configFile), configFile);
        }
        catch (IOException e) {
            LOGGER.error("Error accessing logger configuration file: {}", (Object)e.getMessage(), (Object)e);
            System.exit(-1);
            return null;
        }
    }
}

