/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.pattern;

import java.util.List;
import java.util.regex.Pattern;
import org.conqat.engine.core.pattern.IncludeExcludePatternSupportBase;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.filesystem.AntPatternUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public final class IncludeExcludeAntPatternSupport
extends IncludeExcludePatternSupportBase {
    private boolean caseSensitive;

    public IncludeExcludeAntPatternSupport() {
        this(false);
    }

    public IncludeExcludeAntPatternSupport(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public IncludeExcludeAntPatternSupport(boolean caseSensitive, List<String> includePatterns) {
        this(caseSensitive);
        for (String pattern : includePatterns) {
            this.addIncludePattern(pattern);
        }
    }

    public IncludeExcludeAntPatternSupport(List<String> includePatterns, List<String> excludePatterns) {
        this(false, includePatterns, excludePatterns);
    }

    public IncludeExcludeAntPatternSupport(boolean caseSensitive, List<String> includePatterns, List<String> excludePatterns) {
        this(caseSensitive, includePatterns);
        for (String pattern : excludePatterns) {
            this.addExcludePattern(pattern);
        }
    }

    @Override
    protected Pattern compileToRegexPattern(String pattern) {
        return AntPatternUtils.convertPattern((String)pattern, (boolean)this.caseSensitive);
    }

    public boolean canSubPathsBeIncluded(String directoryPath) {
        if (StringUtils.isEmpty((String)directoryPath)) {
            return true;
        }
        for (Pair excludePattern : CollectionUtils.zip(this.getExcludePatterns(), this.getCompiledExcludePatterns())) {
            if (!IncludeExcludeAntPatternSupport.matchesAllChildren(directoryPath, (String)excludePattern.getFirst(), (Pattern)excludePattern.getSecond())) continue;
            return false;
        }
        for (String include : this.getIncludePatterns()) {
            if (!this.mayMatchChildren(directoryPath, include)) continue;
            return true;
        }
        return this.getIncludePatterns().isEmpty();
    }

    private boolean mayMatchChildren(String directoryPath, String antPattern) {
        if (!antPattern.contains("**") && IncludeExcludeAntPatternSupport.countSlashes(antPattern) <= IncludeExcludeAntPatternSupport.countSlashes(directoryPath)) {
            return false;
        }
        if (!this.caseSensitive) {
            antPattern = antPattern.toLowerCase();
            directoryPath = directoryPath.toLowerCase();
        }
        if (!antPattern.contains("*") && !antPattern.startsWith(directoryPath)) {
            return false;
        }
        String nonWildcardPrefix = IncludeExcludeAntPatternSupport.getNonWildcardPrefix(antPattern);
        return directoryPath.startsWith(nonWildcardPrefix) || nonWildcardPrefix.startsWith(directoryPath);
    }

    private static int countSlashes(String directoryPath) {
        return StringUtils.countCharacter((String)directoryPath, (char)'/');
    }

    private static String getNonWildcardPrefix(String antPattern) {
        int index = antPattern.indexOf(42);
        if (index < 0) {
            return antPattern;
        }
        return antPattern.substring(0, index);
    }

    private static boolean matchesAllChildren(String directoryPath, String antPattern, Pattern pattern) {
        return antPattern.endsWith("**") && pattern.matcher(directoryPath).matches();
    }

    @Override
    public void addMatchAllIncludePattern() {
        this.addIncludePattern("**");
    }
}

