/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.pattern;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public abstract class IncludeExcludePatternSupportBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> includes = new ArrayList<String>();
    private final List<String> excludes = new ArrayList<String>();
    private transient PatternList compiledIncludes = null;
    private transient PatternList compiledExcludes = null;

    public final UnmodifiableList<String> getIncludePatterns() {
        return CollectionUtils.asUnmodifiable(this.includes);
    }

    public final UnmodifiableList<Pattern> getCompiledIncludePatterns() {
        this.compilePatternsIfNeeded();
        return CollectionUtils.asUnmodifiable((List)((Object)this.compiledIncludes));
    }

    public final UnmodifiableList<String> getExcludePatterns() {
        return CollectionUtils.asUnmodifiable(this.excludes);
    }

    public final UnmodifiableList<Pattern> getCompiledExcludePatterns() {
        this.compilePatternsIfNeeded();
        return CollectionUtils.asUnmodifiable((List)((Object)this.compiledExcludes));
    }

    public final synchronized void addIncludePattern(String include) {
        this.includes.add(include);
        if (this.compiledIncludes != null) {
            this.compiledIncludes.add(this.compileToRegexPattern(include));
        }
    }

    public final synchronized void addExcludePattern(String exclude) {
        this.excludes.add(exclude);
        if (this.compiledExcludes != null) {
            this.compiledExcludes.add(this.compileToRegexPattern(exclude));
        }
    }

    public final boolean isIncluded(String name) {
        this.compilePatternsIfNeeded();
        return this.compiledIncludes.emptyOrMatchesAny(name) && !this.isExplicitlyExcluded(name);
    }

    public abstract void addMatchAllIncludePattern();

    public boolean isExplicitlyExcluded(String name) {
        this.compilePatternsIfNeeded();
        return this.compiledExcludes.matchesAny(name);
    }

    private synchronized void compilePatternsIfNeeded() throws PatternSyntaxException {
        if (this.compiledIncludes == null) {
            this.compiledIncludes = new PatternList();
            this.compiledExcludes = new PatternList();
            for (String include : this.includes) {
                this.compiledIncludes.add(this.compileToRegexPattern(include));
            }
            for (String exclude : this.excludes) {
                this.compiledExcludes.add(this.compileToRegexPattern(exclude));
            }
        }
    }

    protected abstract Pattern compileToRegexPattern(String var1) throws PatternSyntaxException;

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        IncludeExcludePatternSupportBase that = (IncludeExcludePatternSupportBase)o;
        return Objects.equals(new HashSet<String>(this.includes), new HashSet<String>(that.includes)) && Objects.equals(new HashSet<String>(this.excludes), new HashSet<String>(that.excludes));
    }

    public final int hashCode() {
        return Objects.hash(new HashSet<String>(this.includes), new HashSet<String>(this.excludes));
    }

    public String toString() {
        return "in: " + String.valueOf(this.includes) + ", out: " + String.valueOf(this.excludes);
    }
}

