/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client;

import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

public class BearerScheme
extends RFC2617Scheme {
    private static final long serialVersionUID = 1L;
    private boolean complete = false;

    public BearerScheme(Charset credentialsCharset) {
        super(credentialsCharset);
    }

    public BearerScheme() {
        this(Consts.ASCII);
    }

    public String getSchemeName() {
        return "bearer";
    }

    public boolean isConnectionBased() {
        return false;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        Args.notNull((Object)credentials, (String)"Credentials");
        Args.notNull((Object)request, (String)"HTTP request");
        String header = "Authorization: Bearer " + credentials.getPassword();
        CharArrayBuffer buffer = new CharArrayBuffer(header.length());
        buffer.append(header);
        return new BufferedHeader(buffer);
    }
}

