/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.List;
import org.rocksdb.BackupEngineOptions;
import org.rocksdb.BackupInfo;
import org.rocksdb.Env;
import org.rocksdb.RestoreOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksObject;

public class BackupEngine
extends RocksObject
implements AutoCloseable {
    protected BackupEngine(long nativeHandle) {
        super(nativeHandle);
    }

    public static BackupEngine open(Env env, BackupEngineOptions options) throws RocksDBException {
        return new BackupEngine(BackupEngine.open(env.nativeHandle_, options.nativeHandle_));
    }

    public void createNewBackup(RocksDB db) throws RocksDBException {
        this.createNewBackup(db, false);
    }

    public void createNewBackup(RocksDB db, boolean flushBeforeBackup) throws RocksDBException {
        assert (this.isOwningHandle());
        this.createNewBackup(this.nativeHandle_, db.nativeHandle_, flushBeforeBackup);
    }

    public void createNewBackupWithMetadata(RocksDB db, String metadata, boolean flushBeforeBackup) throws RocksDBException {
        assert (this.isOwningHandle());
        this.createNewBackupWithMetadata(this.nativeHandle_, db.nativeHandle_, metadata, flushBeforeBackup);
    }

    public List<BackupInfo> getBackupInfo() {
        assert (this.isOwningHandle());
        return this.getBackupInfo(this.nativeHandle_);
    }

    public int[] getCorruptedBackups() {
        assert (this.isOwningHandle());
        return this.getCorruptedBackups(this.nativeHandle_);
    }

    public void garbageCollect() throws RocksDBException {
        assert (this.isOwningHandle());
        this.garbageCollect(this.nativeHandle_);
    }

    public void purgeOldBackups(int numBackupsToKeep) throws RocksDBException {
        assert (this.isOwningHandle());
        this.purgeOldBackups(this.nativeHandle_, numBackupsToKeep);
    }

    public void deleteBackup(int backupId) throws RocksDBException {
        assert (this.isOwningHandle());
        this.deleteBackup(this.nativeHandle_, backupId);
    }

    public void restoreDbFromBackup(int backupId, String dbDir, String walDir, RestoreOptions restoreOptions) throws RocksDBException {
        assert (this.isOwningHandle());
        this.restoreDbFromBackup(this.nativeHandle_, backupId, dbDir, walDir, restoreOptions.nativeHandle_);
    }

    public void restoreDbFromLatestBackup(String dbDir, String walDir, RestoreOptions restoreOptions) throws RocksDBException {
        assert (this.isOwningHandle());
        this.restoreDbFromLatestBackup(this.nativeHandle_, dbDir, walDir, restoreOptions.nativeHandle_);
    }

    private static native long open(long var0, long var2) throws RocksDBException;

    private native void createNewBackup(long var1, long var3, boolean var5) throws RocksDBException;

    private native void createNewBackupWithMetadata(long var1, long var3, String var5, boolean var6) throws RocksDBException;

    private native List<BackupInfo> getBackupInfo(long var1);

    private native int[] getCorruptedBackups(long var1);

    private native void garbageCollect(long var1) throws RocksDBException;

    private native void purgeOldBackups(long var1, int var3) throws RocksDBException;

    private native void deleteBackup(long var1, int var3) throws RocksDBException;

    private native void restoreDbFromBackup(long var1, int var3, String var4, String var5, long var6) throws RocksDBException;

    private native void restoreDbFromLatestBackup(long var1, String var3, String var4, long var5) throws RocksDBException;

    @Override
    protected final native void disposeInternal(long var1);
}

