/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Objects;

public class MemTableInfo {
    private final String columnFamilyName;
    private final long firstSeqno;
    private final long earliestSeqno;
    private final long numEntries;
    private final long numDeletes;

    MemTableInfo(String columnFamilyName, long firstSeqno, long earliestSeqno, long numEntries, long numDeletes) {
        this.columnFamilyName = columnFamilyName;
        this.firstSeqno = firstSeqno;
        this.earliestSeqno = earliestSeqno;
        this.numEntries = numEntries;
        this.numDeletes = numDeletes;
    }

    public String getColumnFamilyName() {
        return this.columnFamilyName;
    }

    public long getFirstSeqno() {
        return this.firstSeqno;
    }

    public long getEarliestSeqno() {
        return this.earliestSeqno;
    }

    public long getNumEntries() {
        return this.numEntries;
    }

    public long getNumDeletes() {
        return this.numDeletes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemTableInfo that = (MemTableInfo)o;
        return this.firstSeqno == that.firstSeqno && this.earliestSeqno == that.earliestSeqno && this.numEntries == that.numEntries && this.numDeletes == that.numDeletes && Objects.equals(this.columnFamilyName, that.columnFamilyName);
    }

    public int hashCode() {
        return Objects.hash(this.columnFamilyName, this.firstSeqno, this.earliestSeqno, this.numEntries, this.numDeletes);
    }

    public String toString() {
        return "MemTableInfo{columnFamilyName='" + this.columnFamilyName + '\'' + ", firstSeqno=" + this.firstSeqno + ", earliestSeqno=" + this.earliestSeqno + ", numEntries=" + this.numEntries + ", numDeletes=" + this.numDeletes + '}';
    }
}

