/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.rocksdb.util.Environment;

public class NativeLibraryLoader {
    private static final NativeLibraryLoader instance = new NativeLibraryLoader();
    private static boolean initialized = false;
    private static final String sharedLibraryName = Environment.getSharedLibraryName("speedb");
    private static final String jniLibraryName = Environment.getJniLibraryName("speedb");
    private static final String fallbackJniLibraryName = Environment.getFallbackJniLibraryName("speedb");
    private static final String jniLibraryFileName = Environment.getJniLibraryFileName("speedb");
    private static final String fallbackJniLibraryFileName = Environment.getFallbackJniLibraryFileName("speedb");
    private static final String tempFilePrefix = "libspeedbjni";
    private static final String tempFileSuffix = Environment.getJniLibraryExtension();

    public static NativeLibraryLoader getInstance() {
        return instance;
    }

    public synchronized void loadLibrary(String tmpDir) throws IOException {
        try {
            System.loadLibrary(sharedLibraryName);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                System.loadLibrary(jniLibraryName);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                if (fallbackJniLibraryName != null) {
                    try {
                        System.loadLibrary(fallbackJniLibraryName);
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
                        // empty catch block
                    }
                }
                this.loadLibraryFromJar(tmpDir);
                return;
            }
        }
    }

    void loadLibraryFromJar(String tmpDir) throws IOException {
        if (!initialized) {
            System.load(this.loadLibraryFromJarToTemp(tmpDir).getAbsolutePath());
            initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File loadLibraryFromJarToTemp(String tmpDir) throws IOException {
        try (InputStream is = null;){
            File temp;
            String libraryFileName = jniLibraryFileName;
            is = this.getClass().getClassLoader().getResourceAsStream(libraryFileName);
            if (is == null) {
                if (fallbackJniLibraryFileName == null) {
                    throw new RuntimeException(libraryFileName + " was not found inside JAR.");
                }
                libraryFileName = fallbackJniLibraryFileName;
                is = this.getClass().getClassLoader().getResourceAsStream(libraryFileName);
                if (is == null) {
                    throw new RuntimeException(libraryFileName + " was not found inside JAR.");
                }
            }
            if (tmpDir == null || tmpDir.isEmpty()) {
                temp = File.createTempFile(tempFilePrefix, tempFileSuffix);
            } else {
                File parentDir = new File(tmpDir);
                if (!parentDir.exists()) {
                    throw new RuntimeException("Directory: " + parentDir.getAbsolutePath() + " does not exist!");
                }
                temp = new File(parentDir, libraryFileName);
                if (temp.exists() && !temp.delete()) {
                    throw new RuntimeException("File: " + temp.getAbsolutePath() + " already exists and cannot be removed.");
                }
                if (!temp.createNewFile()) {
                    throw new RuntimeException("File: " + temp.getAbsolutePath() + " could not be created.");
                }
            }
            if (!temp.exists()) {
                throw new RuntimeException("File " + temp.getAbsolutePath() + " does not exist.");
            }
            temp.deleteOnExit();
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File file = temp;
            return file;
        }
    }

    private NativeLibraryLoader() {
    }
}

