/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Map;
import org.rocksdb.OperationStage;
import org.rocksdb.OperationType;
import org.rocksdb.StateType;
import org.rocksdb.ThreadType;

public class ThreadStatus {
    private final long threadId;
    private final ThreadType threadType;
    private final String dbName;
    private final String cfName;
    private final OperationType operationType;
    private final long operationElapsedTime;
    private final OperationStage operationStage;
    private final long[] operationProperties;
    private final StateType stateType;

    private ThreadStatus(long threadId, byte threadTypeValue, String dbName, String cfName, byte operationTypeValue, long operationElapsedTime, byte operationStageValue, long[] operationProperties, byte stateTypeValue) {
        this.threadId = threadId;
        this.threadType = ThreadType.fromValue(threadTypeValue);
        this.dbName = dbName;
        this.cfName = cfName;
        this.operationType = OperationType.fromValue(operationTypeValue);
        this.operationElapsedTime = operationElapsedTime;
        this.operationStage = OperationStage.fromValue(operationStageValue);
        this.operationProperties = operationProperties;
        this.stateType = StateType.fromValue(stateTypeValue);
    }

    public long getThreadId() {
        return this.threadId;
    }

    public ThreadType getThreadType() {
        return this.threadType;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getCfName() {
        return this.cfName;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public long getOperationElapsedTime() {
        return this.operationElapsedTime;
    }

    public OperationStage getOperationStage() {
        return this.operationStage;
    }

    public long[] getOperationProperties() {
        return this.operationProperties;
    }

    public StateType getStateType() {
        return this.stateType;
    }

    public static String getThreadTypeName(ThreadType threadType) {
        return ThreadStatus.getThreadTypeName(threadType.getValue());
    }

    public static String getOperationName(OperationType operationType) {
        return ThreadStatus.getOperationName(operationType.getValue());
    }

    public static String microsToString(long operationElapsedTime) {
        return ThreadStatus.microsToStringNative(operationElapsedTime);
    }

    public static String getOperationStageName(OperationStage operationStage) {
        return ThreadStatus.getOperationStageName(operationStage.getValue());
    }

    public static String getOperationPropertyName(OperationType operationType, int i) {
        return ThreadStatus.getOperationPropertyName(operationType.getValue(), i);
    }

    public static Map<String, Long> interpretOperationProperties(OperationType operationType, long[] operationProperties) {
        return ThreadStatus.interpretOperationProperties(operationType.getValue(), operationProperties);
    }

    public static String getStateName(StateType stateType) {
        return ThreadStatus.getStateName(stateType.getValue());
    }

    private static native String getThreadTypeName(byte var0);

    private static native String getOperationName(byte var0);

    private static native String microsToStringNative(long var0);

    private static native String getOperationStageName(byte var0);

    private static native String getOperationPropertyName(byte var0, int var1);

    private static native Map<String, Long> interpretOperationProperties(byte var0, long[] var1);

    private static native String getStateName(byte var0);
}

