/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.jsbuild.export;

import com.teamscale.jsbuild.export.ETypescriptType;
import com.teamscale.jsbuild.export.TypescriptType;
import com.teamscale.jsbuild.export.TypescriptTypeExporterBase;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Member;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class PrimitiveExporter
extends TypescriptTypeExporterBase {
    private static final Set<Class<?>> PRIMITIVE_NUMBER_TYPES = CollectionUtils.asHashSet((Object[])new Class[]{Double.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE});

    @Override
    public Optional<TypescriptType> resolveJavaScriptType(Class<?> clazz, AnnotatedType annotatedType, Member member) {
        return PrimitiveExporter.resolvePrimitiveType(clazz).map(javaScriptType -> new TypescriptType((String)javaScriptType, PrimitiveExporter.isNullable(annotatedType)));
    }

    public static Optional<String> resolvePrimitiveType(Class<?> type) {
        ETypescriptType closureType = null;
        if (PrimitiveExporter.isNumber(type)) {
            closureType = ETypescriptType.NUMBER;
        }
        if (PrimitiveExporter.isString(type)) {
            closureType = ETypescriptType.STRING;
        }
        if (PrimitiveExporter.isBoolean(type)) {
            closureType = ETypescriptType.BOOLEAN;
        }
        return Optional.ofNullable(closureType).map(ETypescriptType::getTypeName);
    }

    private static boolean isBoolean(Class<?> type) {
        return Boolean.TYPE == type || Boolean.class.isAssignableFrom(type);
    }

    private static boolean isString(Class<?> type) {
        return String.class.isAssignableFrom(type);
    }

    private static boolean isNumber(Class<?> type) {
        return PRIMITIVE_NUMBER_TYPES.contains(type) || Number.class.isAssignableFrom(type);
    }
}

