/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.jsbuild.export;

import com.teamscale.commons.lang.ToStringHelpers;
import java.util.Objects;

public class TypescriptType {
    private final String type;
    private final boolean nullable;

    public TypescriptType(String type, boolean nullable) {
        this.type = type;
        this.nullable = nullable;
    }

    public String getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String toNullableType() {
        if (this.nullable) {
            return this.getType() + " | null";
        }
        return this.getType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypescriptType other = (TypescriptType)o;
        return this.nullable == other.nullable && Objects.equals(this.type, other.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.nullable);
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }
}

