/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import java.io.PrintStream;
import jetbrains.exodus.tree.Dumpable;
import jetbrains.exodus.tree.patricia.ChildReference;
import jetbrains.exodus.tree.patricia.MutableNode;
import jetbrains.exodus.tree.patricia.NodeBase;
import jetbrains.exodus.tree.patricia.NodeChildren;
import jetbrains.exodus.tree.patricia.NodeChildrenIterator;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import jetbrains.exodus.tree.patricia.PatriciaTreeMutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TreeAwareNodeDecorator
extends NodeBase {
    @NotNull
    private final PatriciaTreeBase tree;
    @NotNull
    private final NodeBase decorated;

    TreeAwareNodeDecorator(@NotNull PatriciaTreeBase tree, @NotNull NodeBase decorated) {
        super(decorated.keySequence, decorated.value);
        this.tree = tree;
        this.decorated = decorated;
    }

    @NotNull
    PatriciaTreeBase getTree() {
        return this.tree;
    }

    @Override
    long getAddress() {
        return this.decorated.getAddress();
    }

    @Override
    boolean isMutable() {
        return this.decorated.isMutable();
    }

    @Override
    MutableNode getMutableCopy(@NotNull PatriciaTreeMutable mutableTree) {
        return this.decorated.getMutableCopy(mutableTree);
    }

    @Override
    NodeBase getChild(@NotNull PatriciaTreeBase tree, byte b) {
        return this.decorated.getChild(tree, b);
    }

    @Override
    @NotNull
    NodeChildrenIterator getChildren(byte b) {
        return this.decorated.getChildren(b);
    }

    @Override
    @NotNull
    NodeChildrenIterator getChildrenRange(byte b) {
        return this.decorated.getChildrenRange(b);
    }

    @Override
    @NotNull
    NodeChildrenIterator getChildrenLast() {
        return this.decorated.getChildrenLast();
    }

    @Override
    @NotNull
    NodeChildren getChildren() {
        return this.decorated.getChildren();
    }

    @Override
    int getChildrenCount() {
        return this.decorated.getChildrenCount();
    }

    @Override
    public void dump(PrintStream out, int level, @Nullable Dumpable.ToString renderer) {
        TreeAwareNodeDecorator.dump(this.tree, this, out, level, renderer);
    }

    private static void dump(PatriciaTreeBase tree, NodeBase node, PrintStream out, int level, @Nullable Dumpable.ToString renderer) {
        out.println(String.format("node %s%s] %s", node.isMutable() ? "(m) [" : Character.valueOf('['), node.getChildrenCount(), renderer == null ? node.toString() : renderer.toString(node)));
        for (ChildReference child : node.getChildren()) {
            TreeAwareNodeDecorator.indent(out, level);
            long childAddress = child.suffixAddress;
            out.println(child.firstByte + " -> " + childAddress);
            TreeAwareNodeDecorator.indent(out, level + 1);
            out.print("+ ");
            if (childAddress == -1L || tree.getLog().hasAddress(childAddress)) {
                TreeAwareNodeDecorator.dump(tree, child.getNode(tree), out, level + 3, renderer);
                continue;
            }
            out.println("[not found]");
        }
    }
}

