/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DescriptorBasedTypeSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactoryImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MethodSignatureBuildingUtilsKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodSignatureMappingKt {
    @NotNull
    public static final String computeJvmDescriptor(@NotNull FunctionDescriptor $this$computeJvmDescriptor, boolean withReturnType, boolean withName) {
        Object object;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$computeJvmDescriptor, "<this>");
        StringBuilder $this$computeJvmDescriptor_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (withName) {
            Object object2;
            if ($this$computeJvmDescriptor instanceof ConstructorDescriptor) {
                object2 = "<init>";
            } else {
                object = $this$computeJvmDescriptor.getName().asString();
                Intrinsics.checkNotNullExpressionValue(object, "name.asString()");
                object2 = object;
            }
            $this$computeJvmDescriptor_u24lambda_u2d1.append((String)object2);
        }
        $this$computeJvmDescriptor_u24lambda_u2d1.append("(");
        object = $this$computeJvmDescriptor.getExtensionReceiverParameter();
        if (object != null) {
            Iterator<ValueParameterDescriptor> iterator2;
            Iterator<ValueParameterDescriptor> it = iterator2 = object;
            boolean bl2 = false;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "it.type");
            MethodSignatureMappingKt.appendErasedType($this$computeJvmDescriptor_u24lambda_u2d1, kotlinType);
        }
        for (ValueParameterDescriptor parameter : $this$computeJvmDescriptor.getValueParameters()) {
            KotlinType kotlinType = parameter.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "parameter.type");
            MethodSignatureMappingKt.appendErasedType($this$computeJvmDescriptor_u24lambda_u2d1, kotlinType);
        }
        $this$computeJvmDescriptor_u24lambda_u2d1.append(")");
        if (withReturnType) {
            if (DescriptorBasedTypeSignatureMappingKt.hasVoidReturnType($this$computeJvmDescriptor)) {
                $this$computeJvmDescriptor_u24lambda_u2d1.append("V");
            } else {
                KotlinType kotlinType = $this$computeJvmDescriptor.getReturnType();
                Intrinsics.checkNotNull(kotlinType);
                object = kotlinType;
                Intrinsics.checkNotNullExpressionValue(object, "returnType!!");
                MethodSignatureMappingKt.appendErasedType($this$computeJvmDescriptor_u24lambda_u2d1, (KotlinType)object);
            }
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static /* synthetic */ String computeJvmDescriptor$default(FunctionDescriptor functionDescriptor, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return MethodSignatureMappingKt.computeJvmDescriptor(functionDescriptor, bl, bl2);
    }

    public static final boolean forceSingleValueParameterBoxing(@NotNull CallableDescriptor f) {
        Intrinsics.checkNotNullParameter(f, "f");
        if (!(f instanceof FunctionDescriptor)) {
            return false;
        }
        if (!Intrinsics.areEqual(((FunctionDescriptor)f).getName().asString(), "remove") || ((FunctionDescriptor)f).getValueParameters().size() != 1 || SpecialBuiltinMembers.isFromJavaOrBuiltins((CallableMemberDescriptor)f)) {
            return false;
        }
        List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)f).getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "f.original.valueParameters");
        Annotated annotated = CollectionsKt.single(list2).getType();
        Intrinsics.checkNotNullExpressionValue(annotated, "f.original.valueParameters.single().type");
        Object object = MethodSignatureMappingKt.mapToJvmType(annotated);
        JvmType.Primitive primitive = object instanceof JvmType.Primitive ? (JvmType.Primitive)object : null;
        if ((primitive == null ? null : primitive.getJvmPrimitiveType()) != JvmPrimitiveType.INT) {
            return false;
        }
        object = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava((FunctionDescriptor)f);
        if (object == null) {
            return false;
        }
        Object overridden = object;
        list2 = overridden.getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "overridden.original.valueParameters");
        annotated = CollectionsKt.single(list2).getType();
        Intrinsics.checkNotNullExpressionValue(annotated, "overridden.original.valueParameters.single().type");
        JvmType overriddenParameterType = MethodSignatureMappingKt.mapToJvmType(annotated);
        annotated = overridden.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(annotated, "overridden.containingDeclaration");
        return Intrinsics.areEqual(DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)annotated), StandardNames.FqNames.mutableCollection.toUnsafe()) && overriddenParameterType instanceof JvmType.Object && Intrinsics.areEqual(((JvmType.Object)overriddenParameterType).getInternalName(), "java/lang/Object");
    }

    @Nullable
    public static final String computeJvmSignature(@NotNull CallableDescriptor $this$computeJvmSignature) {
        MemberDescriptor memberDescriptor;
        SignatureBuildingComponents signatureBuildingComponents;
        Intrinsics.checkNotNullParameter($this$computeJvmSignature, "<this>");
        boolean $i$f$signatures = false;
        SignatureBuildingComponents $this$computeJvmSignature_u24lambda_u2d2 = signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        boolean bl = false;
        if (DescriptorUtils.isLocal($this$computeJvmSignature)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = $this$computeJvmSignature.getContainingDeclaration();
        ClassDescriptor classDescriptor2 = memberDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (memberDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor3 = memberDescriptor;
        if (classDescriptor3.getName().isSpecial()) {
            return null;
        }
        declarationDescriptor = $this$computeJvmSignature.getOriginal();
        MemberDescriptor memberDescriptor2 = memberDescriptor = declarationDescriptor instanceof SimpleFunctionDescriptor ? (SimpleFunctionDescriptor)declarationDescriptor : null;
        if (memberDescriptor == null) {
            return null;
        }
        return MethodSignatureBuildingUtilsKt.signature($this$computeJvmSignature_u24lambda_u2d2, classDescriptor3, MethodSignatureMappingKt.computeJvmDescriptor$default((FunctionDescriptor)memberDescriptor, false, false, 3, null));
    }

    @NotNull
    public static final String getInternalName(@NotNull ClassDescriptor $this$internalName) {
        Intrinsics.checkNotNullParameter($this$internalName, "<this>");
        Object object = DescriptorUtilsKt.getFqNameSafe($this$internalName).toUnsafe();
        Intrinsics.checkNotNullExpressionValue(object, "fqNameSafe.toUnsafe()");
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava((FqNameUnsafe)object);
        if (classId != null) {
            Object it = object = classId;
            boolean bl = false;
            String string2 = JvmClassName.byClassId((ClassId)it).getInternalName();
            Intrinsics.checkNotNullExpressionValue(string2, "byClassId(it).internalName");
            return string2;
        }
        return DescriptorBasedTypeSignatureMappingKt.computeInternalName$default($this$internalName, null, 2, null);
    }

    private static final void appendErasedType(StringBuilder $this$appendErasedType, KotlinType type2) {
        $this$appendErasedType.append(MethodSignatureMappingKt.mapToJvmType(type2));
    }

    @NotNull
    public static final JvmType mapToJvmType(@NotNull KotlinType $this$mapToJvmType) {
        Intrinsics.checkNotNullParameter($this$mapToJvmType, "<this>");
        return (JvmType)DescriptorBasedTypeSignatureMappingKt.mapType$default($this$mapToJvmType, JvmTypeFactoryImpl.INSTANCE, TypeMappingMode.DEFAULT, TypeMappingConfigurationImpl.INSTANCE, null, null, 32, null);
    }
}

