/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.kotlin.com.intellij.core.CoreBundle;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginLoadingError;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginSet;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.util.BuildNumber;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.HtmlChunk;
import org.jetbrains.kotlin.com.intellij.util.lang.UrlClassLoader;

public final class PluginManagerCore {
    public static final PluginId CORE_ID = PluginId.getId("org.jetbrains.kotlin.com.intellij");
    public static final PluginId JAVA_PLUGIN_ID = PluginId.getId("org.jetbrains.kotlin.com.intellij.java");
    static final PluginId JAVA_MODULE_ID = PluginId.getId("org.jetbrains.kotlin.com.intellij.modules.java");
    static final PluginId ALL_MODULES_MARKER = PluginId.getId("org.jetbrains.kotlin.com.intellij.modules.all");
    public static final PluginId SPECIAL_IDEA_PLUGIN_ID = PluginId.getId("IDEA CORE");
    private static final boolean IGNORE_DISABLED_PLUGINS = Boolean.getBoolean("idea.ignore.disabled.plugins");
    private static final MethodType HAS_LOADED_CLASS_METHOD_TYPE = MethodType.methodType(Boolean.TYPE, String.class);
    private static Reference<Map<PluginId, Set<String>>> brokenPluginVersions;
    @Nullable
    private static volatile PluginSet pluginSet;
    public static volatile boolean isUnitTestMode;
    @ApiStatus.Internal
    private static final List<Supplier<? extends HtmlChunk>> pluginErrors;
    private static BuildNumber ourBuildNumber;

    @NotNull
    static @NotNull Map<@NotNull PluginId, @NotNull Set<String>> getBrokenPluginVersions() {
        Map<PluginId, Set<String>> result2;
        if (IGNORE_DISABLED_PLUGINS) {
            Map<PluginId, Set<String>> map = Collections.emptyMap();
            if (map == null) {
                PluginManagerCore.$$$reportNull$$$0(9);
            }
            return map;
        }
        Map<PluginId, Set<String>> map = result2 = brokenPluginVersions == null ? null : brokenPluginVersions.get();
        if (result2 == null) {
            result2 = PluginManagerCore.readBrokenPluginFile();
            brokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result2);
        }
        Map<PluginId, Set<String>> map2 = result2;
        if (map2 == null) {
            PluginManagerCore.$$$reportNull$$$0(10);
        }
        return map2;
    }

    @NotNull
    private static Map<PluginId, Set<String>> readBrokenPluginFile() {
        Map<PluginId, Set<String>> result2 = null;
        Path updatedBrokenPluginFile = PluginManagerCore.getUpdatedBrokenPluginFile();
        if (Files.exists(updatedBrokenPluginFile, new LinkOption[0]) && (result2 = PluginManagerCore.tryReadBrokenPluginsFile(updatedBrokenPluginFile)) != null) {
            PluginManagerCore.getLogger().debug("Using cached broken plugins file");
        }
        if (result2 == null && (result2 = PluginManagerCore.tryReadBrokenPluginsFile(Paths.get(PathManager.getBinPath() + "/brokenPlugins.db", new String[0]))) != null) {
            PluginManagerCore.getLogger().debug("Using broken plugins file from IDE distribution");
        }
        if (result2 != null) {
            Map<PluginId, Set<String>> map = result2;
            if (map == null) {
                PluginManagerCore.$$$reportNull$$$0(11);
            }
            return map;
        }
        Map<PluginId, Set<String>> map = Collections.emptyMap();
        if (map == null) {
            PluginManagerCore.$$$reportNull$$$0(12);
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Map<PluginId, Set<String>> tryReadBrokenPluginsFile(Path brokenPluginsStorage) {
        try (DataInputStream stream2 = new DataInputStream(new BufferedInputStream(Files.newInputStream(brokenPluginsStorage, new OpenOption[0]), 32000));){
            int version = stream2.readUnsignedByte();
            if (version != 2) {
                PluginManagerCore.getLogger().info("Unsupported version of " + brokenPluginsStorage + "(fileVersion=" + version + ", supportedVersion=2)");
                Map<PluginId, Set<String>> map = null;
                return map;
            }
            String buildNumber = stream2.readUTF();
            if (!buildNumber.equals(PluginManagerCore.getBuildNumber().toString())) {
                PluginManagerCore.getLogger().info("Ignoring cached broken plugins file from an earlier IDE build (" + buildNumber + ")");
                Map<PluginId, Set<String>> map = null;
                return map;
            }
            int count = stream2.readInt();
            HashMap<PluginId, Set<String>> result2 = new HashMap<PluginId, Set<String>>(count);
            for (int i = 0; i < count; ++i) {
                PluginId pluginId = PluginId.getId(stream2.readUTF());
                String[] versions2 = new String[stream2.readUnsignedShort()];
                for (int j = 0; j < versions2.length; ++j) {
                    versions2[j] = stream2.readUTF();
                }
                result2.put(pluginId, versions2.length == 1 ? Collections.singleton(versions2[0]) : new HashSet<String>(Arrays.asList(versions2)));
            }
            HashMap<PluginId, Set<String>> hashMap = result2;
            return hashMap;
        }
        catch (NoSuchFileException stream2) {
            return null;
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().error("Failed to read " + brokenPluginsStorage, e);
        }
        return null;
    }

    public static void writePluginsList(@NotNull Collection<PluginId> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        if (writer == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        ArrayList<PluginId> sortedIds = new ArrayList<PluginId>(ids);
        sortedIds.sort(null);
        for (PluginId id : sortedIds) {
            writer.write(id.getIdString());
            writer.write(10);
        }
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        PluginId id;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(20);
        }
        return (id = PluginManagerCore.getPluginOrPlatformByClassName(className)) != null && !CORE_ID.equals(id) ? id : null;
    }

    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className) {
        PluginDescriptor result2;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(21);
        }
        return (result2 = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className)) == null ? null : result2.getPluginId();
    }

    @ApiStatus.Internal
    @Nullable
    public static PluginDescriptor getPluginDescriptorOrPlatformByClassName(@NotNull @NonNls String className) {
        PluginSet pluginSet;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        if ((pluginSet = PluginManagerCore.pluginSet) == null || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("kotlin.") || className.startsWith("groovy.") || !className.contains(".")) {
            return null;
        }
        IdeaPluginDescriptorImpl result2 = null;
        for (IdeaPluginDescriptorImpl o : pluginSet.getRawListOfEnabledModules()) {
            ClassLoader classLoader = o.getClassLoader();
            if (!PluginManagerCore.hasLoadedClass(className, classLoader)) continue;
            result2 = o;
            break;
        }
        if (result2 == null) {
            return null;
        }
        if (!CORE_ID.equals(result2.getPluginId()) || className.startsWith("com.jetbrains.") || className.startsWith("org.jetbrains.") || className.startsWith("org.jetbrains.kotlin.com.intellij.") || className.startsWith("org.intellij.") || className.startsWith("com.android.") || className.startsWith("git4idea.") || className.startsWith("org.angularjs.")) {
            return result2;
        }
        String root = null;
        for (IdeaPluginDescriptorImpl o : pluginSet.enabledPlugins) {
            if (!o.isUseIdeaClassLoader) continue;
            if (root == null && (root = PathManager.getResourceRoot(result2.getClassLoader(), className.replace('.', '/') + ".class")) == null) {
                return null;
            }
            Path path = o.getPluginPath();
            if (!root.startsWith(FileUtilRt.toSystemIndependentName(path.toString()))) continue;
            return o;
        }
        return null;
    }

    private static Path getUpdatedBrokenPluginFile() {
        return Paths.get(PathManager.getConfigPath(), new String[0]).resolve("updatedBrokenPlugins.db");
    }

    private static boolean hasLoadedClass(@NotNull String className, @NotNull ClassLoader loader) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className);
        }
        Class<?> aClass = loader.getClass();
        if (aClass.isAnonymousClass() || aClass.isMemberClass()) {
            aClass = aClass.getSuperclass();
        }
        try {
            return MethodHandles.publicLookup().findVirtual(aClass, "hasLoadedClass", HAS_LOADED_CLASS_METHOD_TYPE).invoke(loader, className);
        }
        catch (IllegalAccessError | IllegalAccessException | NoSuchMethodError throwable) {
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().error(e);
        }
        return false;
    }

    @NotNull
    public static BuildNumber getBuildNumber() {
        BuildNumber result2 = ourBuildNumber;
        if (result2 == null) {
            result2 = BuildNumber.fromPluginsCompatibleBuild();
            if (result2 == null) {
                if (isUnitTestMode) {
                    result2 = BuildNumber.currentVersion();
                } else {
                    try {
                        result2 = ApplicationInfoImpl.getShadowInstance().getApiVersionAsNumber();
                    }
                    catch (RuntimeException ignore) {
                        result2 = BuildNumber.currentVersion();
                    }
                }
            }
            ourBuildNumber = result2;
        }
        BuildNumber buildNumber = result2;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        return buildNumber;
    }

    @Nullable
    public static PluginLoadingError checkBuildNumberCompatibility(@NotNull IdeaPluginDescriptor descriptor2, @NotNull BuildNumber ideBuildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(51);
        }
        if (ideBuildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(52);
        }
        String sinceBuild = descriptor2.getSinceBuild();
        String untilBuild = descriptor2.getUntilBuild();
        try {
            BuildNumber untilBuildNumber;
            BuildNumber sinceBuildNumber;
            BuildNumber buildNumber = sinceBuildNumber = sinceBuild == null ? null : BuildNumber.fromString(sinceBuild, descriptor2.getName(), null);
            if (sinceBuildNumber != null && sinceBuildNumber.compareTo(ideBuildNumber) > 0) {
                return new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.incompatible.since.build", descriptor2.getName(), descriptor2.getVersion(), sinceBuild, ideBuildNumber), PluginManagerCore.message("plugin.loading.error.short.incompatible.since.build", sinceBuild));
            }
            BuildNumber buildNumber2 = untilBuildNumber = untilBuild == null ? null : BuildNumber.fromString(untilBuild, descriptor2.getName(), null);
            if (untilBuildNumber != null && untilBuildNumber.compareTo(ideBuildNumber) < 0) {
                return new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.incompatible.until.build", descriptor2.getName(), descriptor2.getVersion(), untilBuild, ideBuildNumber), PluginManagerCore.message("plugin.loading.error.short.incompatible.until.build", untilBuild));
            }
            return null;
        }
        catch (Exception e) {
            PluginManagerCore.getLogger().error(e);
            return new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.failed.to.load.requirements.for.ide.version", descriptor2.getName()), PluginManagerCore.message("plugin.loading.error.short.failed.to.load.requirements.for.ide.version", new Object[0]));
        }
    }

    @NotNull
    @Nls
    private static Supplier<String> message(final @NotNull @PropertyKey(resourceBundle="messages.CoreBundle") @NotNull @PropertyKey(resourceBundle="messages.CoreBundle") String key, final Object ... params) {
        if (key == null) {
            PluginManagerCore.$$$reportNull$$$0(59);
        }
        if (params == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        return new Supplier<String>(){

            @Override
            public String get() {
                return CoreBundle.message(key, params);
            }
        };
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        return logger;
    }

    static {
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
        pluginErrors = new ArrayList<Supplier<? extends HtmlChunk>>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 32: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 8: 
            case 27: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 56: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 15: 
            case 16: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 23: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendorItem";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompletePlugins";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalErrorsSuppliers";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledIds";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledRequiredIds";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreClassLoader";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 45: 
            case 53: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideBuildNumber";
                break;
            }
            case 54: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 55: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 69: 
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 70: 
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToMap";
                break;
            }
            case 71: 
            case 74: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depProcessed";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginSet";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndClearPluginLoadingErrors";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "readBrokenPluginFile";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePluginsError";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareActions";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrScheduleLoading";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPluginRawList";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "initPlugins";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildNumber";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndInitializePlugins";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPluginIdMap";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonOptionalDependenciesIds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPluginSet";
                break;
            }
            case 7: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 15: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 16: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createPluginException";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorOrPlatformByClassName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDevelopedByJetBrains";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isVendorJetBrains";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "logPlugins";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "preparePluginsError";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingError";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "prepareActions";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFirstPluginName";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "initPlugins";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "disableIncompatiblePlugins";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "checkBuildNumberCompatibility";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "checkEssentialPluginsAreAvailable";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "initializePlugins";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkAndPut";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "loadAndInitializePlugins";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findPlugin";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findPluginByModuleDependency";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isPluginInstalled";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "processAllNonOptionalDependencies";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getNonOptionalDependenciesIds";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatedBundledPlugin";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

