/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.AbstractFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.containers.Interner;

public abstract class Identikit {
    private static final Interner<ByType> ourPlainInterner = Interner.createWeakInterner();
    private static final Interner<ByAnchor> ourAnchorInterner = Interner.createWeakInterner();

    @Nullable
    public abstract PsiElement findPsiElement(@NotNull PsiFile var1, int var2, int var3);

    @Nullable
    public abstract Language getFileLanguage();

    public abstract boolean isForPsiFile();

    @NotNull
    public static ByType fromPsi(@NotNull PsiElement element, @NotNull Language fileLanguage) {
        if (element == null) {
            Identikit.$$$reportNull$$$0(0);
        }
        if (fileLanguage == null) {
            Identikit.$$$reportNull$$$0(1);
        }
        return Identikit.fromTypes(element.getClass(), PsiUtilCore.getElementType(element), fileLanguage);
    }

    @Nullable
    static Pair<ByAnchor, PsiElement> withAnchor(@NotNull PsiElement element, @NotNull Language fileLanguage) {
        if (element == null) {
            Identikit.$$$reportNull$$$0(2);
        }
        if (fileLanguage == null) {
            Identikit.$$$reportNull$$$0(3);
        }
        PsiUtilCore.ensureValid(element);
        if (element.isPhysical()) {
            for (SmartPointerAnchorProvider provider : SmartPointerAnchorProvider.EP_NAME.getExtensions()) {
                PsiElement anchor2 = provider.getAnchor(element);
                if (anchor2 == null || !anchor2.isPhysical() || provider.restoreElement(anchor2) != element) continue;
                ByAnchor anchorKit = new ByAnchor(Identikit.fromPsi(element, fileLanguage), Identikit.fromPsi(anchor2, fileLanguage), provider);
                return Pair.create(ourAnchorInterner.intern(anchorKit), anchor2);
            }
        }
        return null;
    }

    @NotNull
    static ByType fromTypes(@NotNull Class<? extends PsiElement> elementClass, @Nullable IElementType elementType, @NotNull Language fileLanguage) {
        if (elementClass == null) {
            Identikit.$$$reportNull$$$0(4);
        }
        if (fileLanguage == null) {
            Identikit.$$$reportNull$$$0(5);
        }
        ByType byType = ourPlainInterner.intern(new ByType(elementClass, elementType, fileLanguage));
        if (byType == null) {
            Identikit.$$$reportNull$$$0(6);
        }
        return byType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLanguage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromPsi";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withAnchor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromTypes";
                break;
            }
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class ByAnchor
    extends Identikit {
        private final ByType myElementInfo;
        private final ByType myAnchorInfo;
        private final SmartPointerAnchorProvider myAnchorProvider;

        ByAnchor(@NotNull ByType elementInfo, @NotNull ByType anchorInfo, @NotNull SmartPointerAnchorProvider anchorProvider) {
            if (elementInfo == null) {
                ByAnchor.$$$reportNull$$$0(0);
            }
            if (anchorInfo == null) {
                ByAnchor.$$$reportNull$$$0(1);
            }
            if (anchorProvider == null) {
                ByAnchor.$$$reportNull$$$0(2);
            }
            this.myElementInfo = elementInfo;
            this.myAnchorInfo = anchorInfo;
            this.myAnchorProvider = anchorProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByAnchor)) {
                return false;
            }
            ByAnchor anchor2 = (ByAnchor)o;
            if (!this.myElementInfo.equals(anchor2.myElementInfo)) {
                return false;
            }
            if (!this.myAnchorInfo.equals(anchor2.myAnchorInfo)) {
                return false;
            }
            return this.myAnchorProvider.equals(anchor2.myAnchorProvider);
        }

        public int hashCode() {
            return this.myElementInfo.hashCode();
        }

        @Override
        @Nullable
        public PsiElement findPsiElement(@NotNull PsiFile file2, int startOffset, int endOffset) {
            PsiElement anchor2;
            if (file2 == null) {
                ByAnchor.$$$reportNull$$$0(3);
            }
            PsiElement element = (anchor2 = this.myAnchorInfo.findPsiElement(file2, startOffset, endOffset)) == null ? null : this.myAnchorProvider.restoreElement(anchor2);
            return element != null && this.myElementInfo.isAcceptable(element) ? element : null;
        }

        @Override
        @Nullable
        public Language getFileLanguage() {
            return this.myAnchorInfo.getFileLanguage();
        }

        @Override
        public boolean isForPsiFile() {
            return this.myAnchorInfo.isForPsiFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchorInfo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchorProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit$ByAnchor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPsiElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ByType
    extends Identikit {
        private final String myElementClassName;
        private final short myElementTypeId;
        private final String myFileLanguageId;

        private ByType(@NotNull Class<? extends PsiElement> elementClass, @Nullable IElementType elementType, @NotNull Language fileLanguage) {
            if (elementClass == null) {
                ByType.$$$reportNull$$$0(0);
            }
            if (fileLanguage == null) {
                ByType.$$$reportNull$$$0(1);
            }
            this.myElementClassName = elementClass.getName();
            this.myElementTypeId = (short)(elementType != null ? (int)elementType.getIndex() : -1);
            this.myFileLanguageId = fileLanguage.getID();
        }

        @Override
        @Nullable
        public PsiElement findPsiElement(@NotNull PsiFile file2, int startOffset, int endOffset) {
            Language fileLanguage;
            if (file2 == null) {
                ByType.$$$reportNull$$$0(2);
            }
            if ((fileLanguage = Language.findLanguageByID(this.myFileLanguageId)) == null) {
                return null;
            }
            Language actualLanguage = fileLanguage != Language.ANY ? fileLanguage : file2.getViewProvider().getBaseLanguage();
            PsiFile actualLanguagePsi = file2.getViewProvider().getPsi(actualLanguage);
            if (actualLanguagePsi == null) {
                return null;
            }
            return this.findInside(actualLanguagePsi, startOffset, endOffset);
        }

        public PsiElement findInside(@NotNull PsiElement element, int startOffset, int endOffset) {
            PsiElement anchor2;
            if (element == null) {
                ByType.$$$reportNull$$$0(3);
            }
            if ((anchor2 = AbstractFileViewProvider.findElementAt(element, startOffset)) == null && startOffset == element.getTextLength()) {
                anchor2 = PsiTreeUtil.getDeepestLast(element);
            }
            if (anchor2 == null) {
                return null;
            }
            PsiElement result2 = this.findParent(startOffset, endOffset, anchor2);
            if (endOffset == startOffset) {
                while ((result2 == null || result2.getTextRange().getStartOffset() != startOffset) && anchor2.getTextRange().getStartOffset() == endOffset && (anchor2 = PsiTreeUtil.prevLeaf(anchor2, false)) != null) {
                    result2 = this.findParent(startOffset, endOffset, anchor2);
                }
            }
            return result2;
        }

        @Nullable
        private PsiElement findParent(int startOffset, int endOffset, @NotNull PsiElement anchor2) {
            TextRange range;
            if (anchor2 == null) {
                ByType.$$$reportNull$$$0(4);
            }
            if ((range = anchor2.getTextRange()).getStartOffset() != startOffset) {
                return null;
            }
            while (range.getEndOffset() < endOffset) {
                if ((anchor2 = anchor2.getParent()) == null || anchor2 instanceof PsiDirectory) {
                    return null;
                }
                range = anchor2.getTextRange();
            }
            while (range.getEndOffset() == endOffset) {
                if (this.isAcceptable(anchor2)) {
                    return anchor2;
                }
                if ((anchor2 = anchor2.getParent()) == null || anchor2 instanceof PsiDirectory) break;
                range = anchor2.getTextRange();
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByType type2 = (ByType)o;
            return this.myElementTypeId == type2.myElementTypeId && Objects.equals(this.myElementClassName, type2.myElementClassName) && Objects.equals(this.myFileLanguageId, type2.myFileLanguageId);
        }

        public int hashCode() {
            return Objects.hash(this.myElementClassName, this.myElementTypeId, this.myFileLanguageId);
        }

        public String toString() {
            return "Identikit(class='" + this.myElementClassName + '\'' + ", elementType=" + this.myElementTypeId + ", fileLanguage='" + this.myFileLanguageId + '\'' + ')';
        }

        @Override
        @Nullable
        public Language getFileLanguage() {
            return Language.findLanguageByID(this.myFileLanguageId);
        }

        @Override
        public boolean isForPsiFile() {
            if (this.myElementTypeId < 0) {
                return false;
            }
            IElementType elementType = IElementType.find(this.myElementTypeId);
            return elementType instanceof IFileElementType;
        }

        private boolean isAcceptable(@NotNull PsiElement element) {
            if (element == null) {
                ByType.$$$reportNull$$$0(5);
            }
            IElementType type2 = PsiUtilCore.getElementType(element);
            return this.myElementClassName.equals(element.getClass().getName()) && type2 != null && this.myElementTypeId == type2.getIndex();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileLanguage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit$ByType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPsiElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findInside";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findParent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAcceptable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

