/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.text;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.CharSequenceWithStringHash;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;
import org.jetbrains.kotlin.com.intellij.util.text.ByteArrayCharSequence;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayExternalizable;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.kotlin.com.intellij.util.text.ImmutableCharSequence;

final class ImmutableText
extends ImmutableCharSequence
implements CharSequenceWithStringHash,
CharArrayExternalizable {
    final CharSequence myNode;
    private static final ImmutableText EMPTY = new ImmutableText("");
    private transient int hash;
    private InnerLeaf myLastLeaf;

    private ImmutableText(CharSequence node) {
        this.myNode = node;
    }

    static ImmutableText valueOf(@NotNull Object obj) {
        if (obj == null) {
            ImmutableText.$$$reportNull$$$0(0);
        }
        if (obj instanceof ImmutableText) {
            return (ImmutableText)obj;
        }
        if (obj instanceof CharSequence) {
            return ImmutableText.valueOf((CharSequence)obj);
        }
        return ImmutableText.valueOf(String.valueOf(obj));
    }

    private static ImmutableText valueOf(@NotNull CharSequence str) {
        if (str == null) {
            ImmutableText.$$$reportNull$$$0(1);
        }
        if (str instanceof ByteArrayCharSequence) {
            return new ImmutableText(str);
        }
        if (str.length() == 0) {
            return EMPTY;
        }
        return new ImmutableText(str.toString());
    }

    private CharSequence ensureChunked() {
        if (this.length() > 64 && !(this.myNode instanceof CompositeNode)) {
            return ImmutableText.nodeOf(this.myNode, 0, this.length());
        }
        return this.myNode;
    }

    private static CharSequence nodeOf(@NotNull CharSequence node, int offset, int length) {
        if (node == null) {
            ImmutableText.$$$reportNull$$$0(2);
        }
        if (length <= 64) {
            return node.subSequence(offset, offset + length).toString();
        }
        int half = length + 64 >> 1 & 0xFFFFFFC0;
        return new CompositeNode(ImmutableText.nodeOf(node, offset, half), ImmutableText.nodeOf(node, offset + half, length - half));
    }

    @Override
    public int length() {
        return this.myNode.length();
    }

    private ImmutableText concat(ImmutableText that) {
        return that.length() == 0 ? this : (this.length() == 0 ? that : new ImmutableText(ImmutableText.concatNodes(this.ensureChunked(), that.ensureChunked())));
    }

    private ImmutableText subtext(int start) {
        return this.subtext(start, this.length());
    }

    @Override
    public ImmutableCharSequence replace(int start, int end, @NotNull CharSequence seq) {
        if (seq == null) {
            ImmutableText.$$$reportNull$$$0(4);
        }
        if (start == end) {
            return this.insert(start, seq);
        }
        if (seq.length() == 0) {
            return this.delete(start, end);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException();
        }
        return this.subtext(0, start).concat(ImmutableText.valueOf(seq)).concat(this.subtext(end));
    }

    @Override
    public ImmutableText insert(int index2, @NotNull CharSequence seq) {
        if (seq == null) {
            ImmutableText.$$$reportNull$$$0(5);
        }
        if (seq.length() == 0) {
            return this;
        }
        return this.subtext(0, index2).concat(ImmutableText.valueOf(seq)).concat(this.subtext(index2));
    }

    @Override
    public ImmutableText delete(int start, int end) {
        if (start == end) {
            return this;
        }
        if (start > end) {
            throw new IndexOutOfBoundsException();
        }
        return this.subtext(0, start).concat(this.subtext(end));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        return new CharSequenceSubSequence(this, start, end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImmutableText)) {
            return false;
        }
        return CharArrayUtil.regionMatches(this, 0, (ImmutableText)obj);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Strings.stringHashCode(this, 0, this.length());
        }
        return h;
    }

    @Override
    public char charAt(int index2) {
        InnerLeaf leaf = this.myLastLeaf;
        if (leaf == null || index2 < leaf.start || index2 >= leaf.end) {
            this.myLastLeaf = leaf = this.findLeaf(index2);
        }
        return leaf.leafNode.charAt(index2 - leaf.start);
    }

    private InnerLeaf findLeaf(int index2) {
        if (index2 < 0) {
            throw this.outOfRange(index2);
        }
        CharSequence node = this.myNode;
        int nodeLength = node.length();
        int offset = 0;
        while (true) {
            if (index2 >= nodeLength) {
                throw this.outOfRange(index2);
            }
            if (!(node instanceof CompositeNode)) {
                return new InnerLeaf(node, offset, offset + nodeLength);
            }
            CompositeNode composite = (CompositeNode)node;
            int headLength = composite.head.length();
            if (index2 < headLength) {
                node = composite.head;
                nodeLength = headLength;
                continue;
            }
            offset += headLength;
            index2 -= headLength;
            node = composite.tail;
            nodeLength -= headLength;
        }
    }

    private IndexOutOfBoundsException outOfRange(int index2) {
        return new IndexOutOfBoundsException("Index out of range: " + index2 + "; length: " + this.length());
    }

    @Override
    public ImmutableText subtext(int start, int end) {
        if (start < 0 || start > end || end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (start == 0 && end == this.length()) {
            return this;
        }
        if (start == end) {
            return EMPTY;
        }
        return new ImmutableText(this.myNode.subSequence(start, end));
    }

    @Override
    public void getChars(int start, int end, char @NotNull [] dest, int destPos) {
        if (dest == null) {
            ImmutableText.$$$reportNull$$$0(6);
        }
        ImmutableText.getChars(this.myNode, start, end, dest, destPos);
    }

    private static void getChars(CharSequence cs, int start, int end, char @NotNull [] dest, int destPos) {
        if (dest == null) {
            ImmutableText.$$$reportNull$$$0(7);
        }
        if (cs instanceof String) {
            ((String)cs).getChars(start, end, dest, destPos);
        } else if (cs instanceof ByteArrayCharSequence) {
            ((ByteArrayCharSequence)cs).getChars(start, end, dest, destPos);
        } else {
            ((CompositeNode)cs).getChars(start, end, dest, destPos);
        }
    }

    @Override
    @NotNull
    public String toString() {
        String string2 = this.myNode.toString();
        if (string2 == null) {
            ImmutableText.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @NotNull
    private static CharSequence concatNodes(@NotNull CharSequence node1, @NotNull CharSequence node2) {
        int length;
        if (node1 == null) {
            ImmutableText.$$$reportNull$$$0(9);
        }
        if (node2 == null) {
            ImmutableText.$$$reportNull$$$0(10);
        }
        if ((length = node1.length() + node2.length()) <= 64) {
            String string2 = node1.toString().concat(node2.toString());
            if (string2 == null) {
                ImmutableText.$$$reportNull$$$0(11);
            }
            return string2;
        }
        CharSequence head = node1;
        CharSequence tail = node2;
        if (ImmutableText.shouldRebalance(head, tail)) {
            do {
                if (((CompositeNode)tail).head.length() <= ((CompositeNode)tail).tail.length()) continue;
                tail = ((CompositeNode)tail).rightRotation();
            } while (ImmutableText.shouldRebalance(head = ImmutableText.concatNodes(head, ((CompositeNode)tail).head), tail = ((CompositeNode)tail).tail));
        } else if (ImmutableText.shouldRebalance(tail, head)) {
            do {
                if (((CompositeNode)head).tail.length() <= ((CompositeNode)head).head.length()) continue;
                head = ((CompositeNode)head).leftRotation();
            } while (ImmutableText.shouldRebalance(tail = ImmutableText.concatNodes(((CompositeNode)head).tail, tail), head = ((CompositeNode)head).head));
        }
        return new CompositeNode(head, tail);
    }

    private static boolean shouldRebalance(CharSequence shorter, CharSequence longer) {
        return shorter.length() << 1 < longer.length() && longer instanceof CompositeNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "concatNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "valueOf";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "nodeOf";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChars";
                break;
            }
            case 8: 
            case 11: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "concatNodes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class CompositeNode
    implements CharSequence {
        final int count;
        final CharSequence head;
        final CharSequence tail;

        CompositeNode(CharSequence head, CharSequence tail) {
            this.count = head.length() + tail.length();
            this.head = head;
            this.tail = tail;
        }

        @Override
        public int length() {
            return this.count;
        }

        @Override
        public char charAt(int index2) {
            int headLength = this.head.length();
            return index2 < headLength ? this.head.charAt(index2) : this.tail.charAt(index2 - headLength);
        }

        CompositeNode rightRotation() {
            CharSequence P3 = this.head;
            if (!(P3 instanceof CompositeNode)) {
                return this;
            }
            CharSequence A = ((CompositeNode)P3).head;
            CharSequence B = ((CompositeNode)P3).tail;
            CharSequence C = this.tail;
            return new CompositeNode(A, new CompositeNode(B, C));
        }

        CompositeNode leftRotation() {
            CharSequence Q = this.tail;
            if (!(Q instanceof CompositeNode)) {
                return this;
            }
            CharSequence B = ((CompositeNode)Q).head;
            CharSequence C = ((CompositeNode)Q).tail;
            CharSequence A = this.head;
            return new CompositeNode(new CompositeNode(A, B), C);
        }

        void getChars(int start, int end, char @NotNull [] dest, int destPos) {
            int cesure;
            if (dest == null) {
                CompositeNode.$$$reportNull$$$0(0);
            }
            if (end <= (cesure = this.head.length())) {
                ImmutableText.getChars(this.head, start, end, dest, destPos);
            } else if (start >= cesure) {
                ImmutableText.getChars(this.tail, start - cesure, end - cesure, dest, destPos);
            } else {
                ImmutableText.getChars(this.head, start, cesure, dest, destPos);
                ImmutableText.getChars(this.tail, 0, end - cesure, dest, destPos + cesure - start);
            }
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            int cesure = this.head.length();
            if (end <= cesure) {
                return this.head.subSequence(start, end);
            }
            if (start >= cesure) {
                return this.tail.subSequence(start - cesure, end - cesure);
            }
            if (start == 0 && end == this.count) {
                return this;
            }
            if (end - start < 64) {
                char[] data2 = new char[end - start];
                ImmutableText.getChars(this.head, start, cesure, data2, 0);
                ImmutableText.getChars(this.tail, 0, end - cesure, data2, cesure - start);
                return new String(data2);
            }
            return ImmutableText.concatNodes(this.head.subSequence(start, cesure), this.tail.subSequence(0, end - cesure));
        }

        @Override
        @NotNull
        public String toString() {
            int len = this.length();
            char[] data2 = new char[len];
            this.getChars(0, len, data2, 0);
            return new String(data2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText$CompositeNode", "getChars"));
        }
    }

    private static final class InnerLeaf {
        final CharSequence leafNode;
        final int start;
        final int end;

        private InnerLeaf(@NotNull CharSequence leafNode, int start, int end) {
            if (leafNode == null) {
                InnerLeaf.$$$reportNull$$$0(0);
            }
            this.leafNode = leafNode;
            this.start = start;
            this.end = end;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leafNode", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText$InnerLeaf", "<init>"));
        }
    }
}

