/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import javax.annotation.Nonnull;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexVisitor;

public class CharacterTree
extends RegexTree
implements CharacterClassElementTree {
    private final int codePoint;
    private final boolean isEscapeSequence;

    public CharacterTree(RegexSource source, IndexRange range, int codePoint, boolean isEscapeSequence, FlagSet activeFlags) {
        super(source, range, activeFlags);
        this.codePoint = codePoint;
        this.isEscapeSequence = isEscapeSequence;
    }

    public int codePointOrUnit() {
        return this.codePoint;
    }

    public boolean isEscapeSequence() {
        return this.isEscapeSequence;
    }

    public String characterAsString() {
        return String.valueOf(Character.toChars(this.codePoint));
    }

    @Override
    public void accept(RegexVisitor visitor2) {
        visitor2.visitCharacter(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.CHARACTER;
    }

    @Override
    @Nonnull
    public CharacterClassElementTree.Kind characterClassElementKind() {
        return CharacterClassElementTree.Kind.PLAIN_CHARACTER;
    }

    @Override
    @Nonnull
    public AutomatonState.TransitionType incomingTransitionType() {
        return AutomatonState.TransitionType.CHARACTER;
    }
}

