/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.java;

import javax.annotation.CheckForNull;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.SourceCharacter;

public class JavaUnicodeEscapeParser {
    private final RegexSource source;
    private final String sourceText;
    private final int textLength;
    private int index;
    private SourceCharacter current;
    private boolean isEscaping = false;

    public JavaUnicodeEscapeParser(RegexSource source) {
        this.source = source;
        this.sourceText = source.getSourceText();
        this.textLength = this.sourceText.length();
        this.index = 0;
        this.moveNext();
    }

    public void resetTo(int index2) {
        this.index = index2;
        this.moveNext();
    }

    @CheckForNull
    public SourceCharacter getCurrent() {
        return this.current;
    }

    public void moveNext() {
        char ch;
        boolean isEscapedUnicode;
        if (this.index >= this.textLength) {
            this.current = null;
            return;
        }
        int startIndex = this.index;
        boolean isBackslash = this.sourceText.charAt(this.index) == '\\';
        boolean bl = isEscapedUnicode = isBackslash && this.index < this.textLength - 1 && this.sourceText.charAt(this.index + 1) == 'u';
        if (isEscapedUnicode && !this.isEscaping) {
            this.index += 2;
            while (this.sourceText.charAt(this.index) == 'u') {
                ++this.index;
            }
            StringBuilder codePoint = new StringBuilder(4);
            int i = 0;
            while (i < 4 && this.index < this.textLength) {
                codePoint.append(this.sourceText.charAt(this.index));
                ++i;
                ++this.index;
            }
            ch = (char)Integer.parseInt(codePoint.toString(), 16);
        } else {
            ch = this.sourceText.charAt(this.index);
            ++this.index;
            this.isEscaping = isBackslash && !this.isEscaping;
        }
        this.current = new SourceCharacter(this.source, new IndexRange(startIndex, this.index), ch, isEscapedUnicode);
    }
}

