/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S1066")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/sonarsource/kotlin/checks/CollapsibleIfStatementsCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "getCollapsibleIfStatement", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getIfStatementWithoutElse", "visitIfExpression", "", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class CollapsibleIfStatementsCheck
extends AbstractCheck {
    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (expression2.getElseKeyword() != null) {
            return;
        }
        KtExpression ktExpression = expression2.getThen();
        Intrinsics.checkNotNull(ktExpression);
        KtIfExpression collapsibleIfStatement = this.getCollapsibleIfStatement(ktExpression);
        if (collapsibleIfStatement != null) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = expression2.getIfKeyword();
            Intrinsics.checkNotNullExpressionValue(psiElement, "getIfKeyword(...)");
            Pair[] pairArray = new Pair[]{TuplesKt.to(collapsibleIfStatement.getIfKeyword(), "")};
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, psiElement, "Merge this \"if\" statement with the nested one.", this.locationListOf(kotlinFileContext, pairArray), null, 8, null);
        }
    }

    private final KtIfExpression getCollapsibleIfStatement(KtExpression expression2) {
        return expression2 instanceof KtBlockExpression ? (((KtBlockExpression)expression2).getStatements().size() == 1 ? this.getIfStatementWithoutElse(((KtBlockExpression)expression2).getFirstStatement()) : null) : this.getIfStatementWithoutElse(expression2);
    }

    private final KtIfExpression getIfStatementWithoutElse(KtExpression expression2) {
        return expression2 instanceof KtIfExpression && ((KtIfExpression)expression2).getElseKeyword() == null ? (KtIfExpression)expression2 : null;
    }
}

