/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.IgnoredOperationStatusCheck;

@Rule(key="S899")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/sonarsource/kotlin/checks/IgnoredOperationStatusCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class IgnoredOperationStatusCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public IgnoredOperationStatusCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{FunMatcherKt.FunMatcher$default("java.io.File", null, null, null, false, null, null, null, null, null, functionsToVisit.1.INSTANCE, 1022, null), FunMatcherKt.FunMatcher$default("java.util.Iterator", "hasNext", null, null, false, null, null, null, null, null, functionsToVisit.2.INSTANCE, 1020, null), FunMatcherKt.FunMatcher$default("kotlin.collections.Iterator", "hasNext", null, null, false, null, null, null, null, null, functionsToVisit.3.INSTANCE, 1020, null), FunMatcherKt.FunMatcher$default("kotlin.collections.MutableIterator", "hasNext", null, null, false, null, null, null, null, null, functionsToVisit.4.INSTANCE, 1020, null), FunMatcherKt.FunMatcher$default("java.util.Enumeration", "hasMoreElements", null, null, false, null, null, null, null, null, functionsToVisit.5.INSTANCE, 1020, null), FunMatcherKt.FunMatcher$default("java.util.concurrent.locks.Lock", "tryLock", null, null, false, null, null, null, null, null, null, 2044, null), FunMatcherKt.FunMatcher$default("java.util.concurrent.locks.Condition", "await", null, null, false, null, null, null, null, null, functionsToVisit.6.INSTANCE, 1020, null), FunMatcherKt.FunMatcher$default("java.util.concurrent.locks.Condition", null, null, null, false, null, null, null, null, null, functionsToVisit.7.INSTANCE, 1022, null), FunMatcherKt.FunMatcher$default("java.util.concurrent.CountDownLatch", "await", null, null, false, null, null, null, null, null, functionsToVisit.8.INSTANCE, 1020, null), FunMatcherKt.FunMatcher$default("java.util.concurrent.Semaphore", "tryAcquire", null, null, false, null, null, null, null, null, null, 2044, null), FunMatcherKt.FunMatcher$default("java.util.concurrent.BlockingQueue", null, null, null, false, null, null, null, null, null, functionsToVisit.9.INSTANCE, 1022, null)};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        block4: {
            Object object;
            Object resultingDescriptor;
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter(callExpression, "callExpression");
                    Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
                    Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
                    if (!BindingContextUtilsKt.isUsedAsStatement(callExpression, kotlinFileContext.getBindingContext())) break block4;
                    Object obj = resolvedCall2.getResultingDescriptor();
                    if (obj == null) break block4;
                    resultingDescriptor = obj;
                    boolean bl = false;
                    KotlinType kotlinType = resultingDescriptor.getReturnType();
                    object = kotlinType;
                    if (object == null) break block5;
                    Intrinsics.checkNotNull(object);
                    object = ApiExtensionsKt.simpleName(kotlinType);
                    if (object != null) break block6;
                }
                object = "this method";
            }
            Object returnType2 = object;
            String message2 = "Do something with the \"" + (String)returnType2 + "\" value returned by \"" + resultingDescriptor.getName() + "\".";
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, message2, null, null, 12, null);
        }
    }
}

