/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.StringLiteralDuplicatedCheck;

@Rule(key="S1192")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000eH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/sonarsource/kotlin/checks/StringLiteralDuplicatedCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "threshold", "", "getThreshold", "()I", "setThreshold", "(I)V", "check", "", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "occurrencesMap", "", "", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "collectStringTemplatesNotInAnnotations", "Lkotlin/sequences/Sequence;", "node", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nStringLiteralDuplicatedCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringLiteralDuplicatedCheck.kt\norg/sonarsource/kotlin/checks/StringLiteralDuplicatedCheck\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,86:1\n1003#2:87\n1037#2,3:88\n1040#2,3:98\n372#3,7:91\n*S KotlinDebug\n*F\n+ 1 StringLiteralDuplicatedCheck.kt\norg/sonarsource/kotlin/checks/StringLiteralDuplicatedCheck\n*L\n75#1:87\n75#1:88,3\n75#1:98,3\n75#1:91,7\n*E\n"})
public final class StringLiteralDuplicatedCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="threshold", description="Number of times a literal must be duplicated to trigger an issue", defaultValue="3")
    private int threshold = 3;
    private static final int DEFAULT_THRESHOLD = 3;
    private static final int MINIMAL_LITERAL_LENGTH = 5;
    @NotNull
    private static final Regex NO_SEPARATOR_REGEXP = new Regex("\\w++");

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    private final void check(KotlinFileContext context, Map<String, ? extends List<? extends KtStringTemplateExpression>> occurrencesMap) {
        Iterator<Map.Entry<String, ? extends List<? extends KtStringTemplateExpression>>> iterator2 = occurrencesMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            List<? extends KtStringTemplateExpression> occurrences2 = iterator2.next().getValue();
            int size = occurrences2.size();
            if (size < this.threshold) continue;
            KtStringTemplateExpression first = occurrences2.get(0);
            this.reportIssue(context, (PsiElement)first, "Define a constant instead of duplicating this literal \"" + ApiExtensionsKt.asString(first) + "\" " + size + " times.", SequencesKt.toList(SequencesKt.map(SequencesKt.drop(CollectionsKt.asSequence((Iterable)occurrences2), 1), (Function1)new Function1<KtStringTemplateExpression, SecondaryLocation>(context){
                final /* synthetic */ KotlinFileContext $context;
                {
                    this.$context = $context;
                    super(1);
                }

                @NotNull
                public final SecondaryLocation invoke(@NotNull KtStringTemplateExpression it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(this.$context, it), "Duplication");
                }
            })), (Double)((double)size - 1.0));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitKtFile(@NotNull KtFile file2, @NotNull KotlinFileContext context) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(context, "context");
        Sequence sequence2 = SequencesKt.filter(SequencesKt.map(this.collectStringTemplatesNotInAnnotations(file2), visitKtFile.occurrences.1.INSTANCE), visitKtFile.occurrences.2.INSTANCE);
        boolean $i$f$groupBy = false;
        void var6_5 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            String text;
            Pair pair = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-StringLiteralDuplicatedCheck$visitKtFile$occurrences$52 = false;
            String key$iv$iv = text = (String)pair.component2();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-StringLiteralDuplicatedCheck$visitKtFile$occurrences$52 = (Pair)element$iv$iv;
            List list2 = list$iv$iv;
            boolean bl = false;
            list2.add((KtStringTemplateExpression)it.getFirst());
        }
        Map occurrences2 = destination$iv$iv;
        this.check(context, occurrences2);
    }

    private final Sequence<KtStringTemplateExpression> collectStringTemplatesNotInAnnotations(PsiElement node) {
        Sequence<KtStringTemplateExpression> sequence2;
        if (node instanceof KtStringTemplateExpression && !((KtStringTemplateExpression)node).hasInterpolation()) {
            KtStringTemplateExpression[] ktStringTemplateExpressionArray = new KtStringTemplateExpression[]{node};
            sequence2 = SequencesKt.sequenceOf(ktStringTemplateExpressionArray);
        } else if (node instanceof KtAnnotationEntry) {
            sequence2 = SequencesKt.emptySequence();
        } else {
            PsiElement[] psiElementArray = node.getChildren();
            Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
            sequence2 = SequencesKt.flatMap(ArraysKt.asSequence((Object[])psiElementArray), (Function1)new Function1<PsiElement, Sequence<? extends KtStringTemplateExpression>>(this){
                final /* synthetic */ StringLiteralDuplicatedCheck this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Sequence<KtStringTemplateExpression> invoke(PsiElement it) {
                    Intrinsics.checkNotNull(it);
                    return StringLiteralDuplicatedCheck.access$collectStringTemplatesNotInAnnotations(this.this$0, it);
                }
            });
        }
        return sequence2;
    }

    public static final /* synthetic */ Regex access$getNO_SEPARATOR_REGEXP$cp() {
        return NO_SEPARATOR_REGEXP;
    }

    public static final /* synthetic */ Sequence access$collectStringTemplatesNotInAnnotations(StringLiteralDuplicatedCheck $this, PsiElement node) {
        return $this.collectStringTemplatesNotInAnnotations(node);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/sonarsource/kotlin/checks/StringLiteralDuplicatedCheck$Companion;", "", "()V", "DEFAULT_THRESHOLD", "", "MINIMAL_LITERAL_LENGTH", "NO_SEPARATOR_REGEXP", "Lkotlin/text/Regex;", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

