/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.sonarsource.kotlin.checks.ComparableTree;
import org.sonarsource.kotlin.checks.SyntacticEquivalence;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J \u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\r"}, d2={"Lorg/sonarsource/kotlin/checks/SyntacticEquivalence;", "", "()V", "areEquivalent", "", "first", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "second", "findDuplicatedGroups", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "list", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nSyntacticEquivalence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntacticEquivalence.kt\norg/sonarsource/kotlin/checks/SyntacticEquivalence\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,91:1\n1477#2:92\n1502#2,3:93\n1505#2,3:103\n766#2:106\n857#2,2:107\n372#3,7:96\n*S KotlinDebug\n*F\n+ 1 SyntacticEquivalence.kt\norg/sonarsource/kotlin/checks/SyntacticEquivalence\n*L\n53#1:92\n53#1:93,3\n53#1:103,3\n54#1:106\n54#1:107,2\n53#1:96,7\n*E\n"})
public final class SyntacticEquivalence {
    @NotNull
    public static final SyntacticEquivalence INSTANCE = new SyntacticEquivalence();

    private SyntacticEquivalence() {
    }

    private final boolean areEquivalent(Iterator<? extends PsiElement> first, Iterator<? extends PsiElement> second) {
        Iterator<? extends PsiElement> firstIterator = first;
        Iterator<? extends PsiElement> secondIterator = second;
        while (firstIterator.hasNext() && secondIterator.hasNext()) {
            if (this.areEquivalent(firstIterator.next(), secondIterator.next())) continue;
            return false;
        }
        return !firstIterator.hasNext() && !secondIterator.hasNext();
    }

    public final boolean areEquivalent(@NotNull PsiElement first, @NotNull PsiElement second) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        if (first == second) {
            return true;
        }
        if (!Intrinsics.areEqual(first.getClass(), second.getClass())) {
            return false;
        }
        PsiElement[] psiElementArray = first.getChildren();
        Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
        Iterator<Object> leftChildrenIterator2 = SequencesKt.filter(ArraysKt.asSequence((Object[])psiElementArray), areEquivalent.leftChildrenIterator.1.INSTANCE).iterator();
        PsiElement[] psiElementArray2 = second.getChildren();
        Intrinsics.checkNotNullExpressionValue(psiElementArray2, "getChildren(...)");
        Iterator<Object> rightChildrenIterator2 = SequencesKt.filter(ArraysKt.asSequence((Object[])psiElementArray2), areEquivalent.rightChildrenIterator.1.INSTANCE).iterator();
        if (!leftChildrenIterator2.hasNext() && !rightChildrenIterator2.hasNext()) {
            return Intrinsics.areEqual(first.getText(), second.getText());
        }
        return this.areEquivalent(leftChildrenIterator2, rightChildrenIterator2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<KtElement>> findDuplicatedGroups(@NotNull List<? extends KtElement> list2) {
        void $this$filterTo$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(list2, "list");
        Iterable $this$groupBy$iv = list2;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            KtElement p0 = (KtElement)element$iv$iv;
            boolean bl = false;
            ComparableTree key$iv$iv = new ComparableTree(p0);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = destination$iv$iv.values();
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            List group = (List)element$iv$iv;
            boolean bl = false;
            if (!(group.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

