/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.user.avatar;

import com.teamscale.core.utils.VelocityEngineUtils;
import java.util.HashMap;
import java.util.stream.IntStream;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.commons.xml.XMLUtils;
import org.jetbrains.annotations.VisibleForTesting;

public final class GeneratedAvatarUtils {
    private static final int NOT_FOUND = -1;
    private static final String UNKNOWN_INITIAL = "?";
    private static final String FIRST_CHAR_LETTER_REGEX = "^[A-Za-z].*$";
    private static final String EMAIL_REGEX = "\\S*@\\S*\\s?";
    private static final int[] HUES = new int[]{0, 60, 186, 300, 1, 148, 199, 327, 343, 35, 240, 148, 37, 172, 222, 338, 355, 171, 62, 96, 96, 229, 277, 336, 60, 2, 66, 169, 13, 329, 304, 27, 208, 240, 4, 108, 330, 194, 198, 170, 35, 42, 162, 273, 341, 30, 95, 138, 212, 307, 150, 283, 189, 14, 220, 92, 318, 32, 351, 324, 63, 125, 206, 35, 73, 274, 181, 0, 240, 181, 25, 30, 54, 168, 345, 204, 96, 140, 0, 103, 273, 42, 236, 18, 335, 19, 278, 58, 150, 54, 279, 277, 281, 209, 260, 356, 26, 21, 200, 189, 339, 77, 213, 337, 88, 183, 115, 152, 229, 62, 13, 69, 3, 12, 142, 325, 343, 151, 3, 346, 303, 298, 15, 173, 56, 23, 116, 210, 239, 39, 260, 164, 344, 205, 270, 347, 188, 138, 276, 70, 209, 188, 201, 5, 285, 190, 143, 47, 164, 318, 53, 241, 312, 352, 204, 25, 176, 325, 97, 309, 240, 317, 143, 208, 332, 10, 9, 42, 200, 125, 32, 46, 349, 32, 72, 3, 264, 240, 177, 16, 49, 220, 147, 320, 328, 135, 160, 170, 279, 60, 79, 182, 280, 308, 279, 308, 46, 88, 73, 56, 332, 349, 15, 200, 324, 23, 45, 357, 311, 145, 27, 247, 333, 330, 141, 137, 211, 225, 25, 98, 173, 147, 252, 76, 131, 211, 317, 343, 15, 25, 26, 12, 150, 232, 11, 0, 126, 180, 16, 271, 205, 61, 22, 191, 123, 44, 161, 64, 107, 72, 90, 88, 149, 352, 237, 344, 214, 37, 337, 204, 162, 81, 281, 101, 234, 191, 316, 322, 46, 189, 31, 0, 191, 274, 13, 180, 180, 33, 352, 207, 199, 304, 302, 43, 23, 216, 145, 218, 35, 225, 200, 294, 358, 351, 129, 75, 19, 318, 355, 183, 343, 228, 345, 321, 139, 9, 159, 347, 219, 193, 38, 337, 191, 267, 201, 183, 252, 43, 31, 334, 76, 339, 17, 53, 48, 323, 31, 323, 342, 63, 240, 105, 166, 309, 304, 120, 341, 34, 36, 20, 101, 157, 227, 43, 300, 154, 259, 290, 23, 350, 24, 356, 228, 228, 276, 285, 139, 202, 36, 243, 163, 117, 338, 202, 197, 57, 162, 173, 23, 182, 49, 300, 181, 30, 150, 285, 328, 3, 91, 162, 96, 177, 294, 330, 330, 321, 215, 290, 41, 286, 30, 79, 249, 267, 195, 213, 45, 10, 107, 145, 163, 211, 173, 352, 172, 123, 121, 352, 240, 345, 23, 86, 134, 231, 111, 316, 201, 31, 12, 304, 135, 64, 340, 128, 346, 83, 137, 173, 349, 226, 223, 7, 240, 200, 230, 353, 96, 224, 0, 49, 4, 157, 59, 6, 237, 12, 264, 258, 85, 66, 260, 180, 162, 72, 345, 17, 10, 261, 160, 44, 176, 20, 356, 25, 189, 263, 253, 188, 338, 8, 102, 74, 90, 207, 15, 23, 88, 20, 325, 291, 12, 160, 5, 222, 267, 333, 331, 15, 183, 160, 297, 14, 346, 359, 155, 190, 120, 32, 164, 300, 291, 338, 145, 196, 180, 27, 22, 267, 31, 81, 333, 203, 210, 97, 212, 207, 351, 54, 318, 318, 194, 307, 240, 343, 67, 1, 276, 200, 76, 164, 206, 274, 244, 71, 351, 210, 78, 48, 135, 295, 2, 76, 357, 40, 14, 211, 196, 356, 354, 358, 335, 49, 303, 227, 346, 165, 55, 333, 205, 234, 347, 152, 176, 150, 327, 330, 288, 155, 316, 181, 357, 37, 207, 198, 358, 326, 168, 325, 191, 68, 321, 318, 20, 191, 309, 174, 74, 190, 100, 95, 19, 46, 93, 44, 128, 150, 18, 10, 262, 199, 306, 85, 278, 67, 131, 262, 284, 306, 341, 357, 38, 128, 195, 91, 179, 20, 30, 75, 207, 181, 94, 129, 345, 344, 72, 105, 171, 211, 27, 115, 250, 72, 331, 109, 273, 32, 240, 33, 38, 254, 19, 168, 327, 10, 44, 197, 335, 219, 19, 156, 331, 170, 250, 337, 337, 147, 235, 15, 59, 35, 344, 132, 356, 30, 352, 302, 142, 311, 345, 167, 225, 352, 331, 255, 222, 61, 150, 297, 57, 66, 166, 110, 132, 16, 197, 114, 48, 13, 125, 237, 3, 353, 337, 242, 185, 43, 209, 159, 190, 12, 79, 12, 47, 274, 162, 19, 221, 166, 23, 315, 56, 63, 108, 60, 287, 57, 160, 126, 29, 295, 167, 313, 19, 26, 348, 265, 212, 339, 197, 269, 318, 115, 10, 140, 120, 114, 185, 332, 295, 171, 7, 184, 103, 29, 216, 150, 30, 169, 348, 245, 128, 316, 26, 33, 95, 338, 345, 204, 333, 240, 4, 228, 286, 16, 282, 288, 84, 282, 38, 174, 224, 17, 155, 175, 37, 351, 21, 43, 40, 178, 12, 60, 148, 125, 345, 7, 60, 204, 350, 327, 189, 199, 150, 192, 158, 312, 38, 174, 230, 51, 335, 51, 338, 286, 284, 324, 130, 4, 42, 31, 197, 23, 18, 146, 12, 57, 63, 312, 112, 58, 234, 85, 218, 215, 255, 18, 223, 53, 335, 42, 5, 313, 5, 45, 98, 225, 190, 34, 238, 17, 91, 7, 198, 271, 32, 0, 212, 39, 155, 43, 49, 242, 202, 306, 37, 102, 189, 95, 45, 227, 323, 92, 314, 34, 266, 321, 170, 338, 107, 138, 22, 107, 22, 332, 342, 211, 26, 81, 241, 121, 14, 89, 350, 275, 350, 202, 198, 223, 277, 91, 309, 63, 295, 0, 9, 317, 11, 232, 35, 330, 235, 135, 14, 352, 266, 288, 139, 122, 166, 302, 80, 260, 39, 169, 237, 178, 334, 155, 267, 195, 341, 144, 220, 330, 141, 302, 316, 206, 337, 52, 187, 321, 320, 4, 47, 289, 144, 217, 88, 82, 10, 198, 84, 55, 156, 28, 359, 214, 104, 339, 288, 359, 32, 287, 167, 359, 331, 37, 43, 356, 225, 163, 138, 15, 74, 254, 153, 215, 64, 165, 340, 298, 205, 282, 35, 291, 95, 279, 321, 39, 9, 27, 139, 23, 16, 191, 160, 33, 45, 216, 315, 11, 69, 46, 129, 178, 157, 341, 356, 176, 195, 165, 311, 258, 73, 141, 55, 322, 160, 184, 187, 2, 252, 166, 53, 147, 345, 86, 204, 127, 345, 19, 320, 31};
    private static final String AVATAR_TEMPLATE_PATH = "com/teamscale/ui/user/avatar/avatar-template.svg";

    public static byte[] generateSvgAvatar(String userName) {
        HashMap<String, String> templateParameters = new HashMap<String, String>();
        int baseHueValue = HUES[Math.abs(userName.hashCode()) % HUES.length];
        templateParameters.put("backgroundColor", GeneratedAvatarUtils.getBackgroundColor(baseHueValue));
        templateParameters.put("textColor", GeneratedAvatarUtils.getTextColor(baseHueValue));
        String text = GeneratedAvatarUtils.getInitials(userName);
        templateParameters.put("text", text);
        String svgContent = VelocityEngineUtils.renderTemplate((String)AVATAR_TEMPLATE_PATH, templateParameters);
        return StringUtils.stringToBytes((String)svgContent);
    }

    private static String getTextColor(int hueValue) {
        return "oklch(55% 0.23 " + hueValue + ")";
    }

    private static String getBackgroundColor(int hueValue) {
        return "oklch(95% 0.02 " + hueValue + ")";
    }

    @VisibleForTesting
    static String getInitials(String userName) {
        String sanitizedUserName = GeneratedAvatarUtils.getSanitizedUserName(userName);
        if (StringUtils.isEmpty((String)sanitizedUserName)) {
            return UNKNOWN_INITIAL;
        }
        if (sanitizedUserName.length() == 1) {
            return GeneratedAvatarUtils.firstCharacterAsUpper(sanitizedUserName);
        }
        String[] parts = sanitizedUserName.split(" ");
        if (parts.length == 1) {
            return GeneratedAvatarUtils.firstCharacterAsUpper(sanitizedUserName);
        }
        return GeneratedAvatarUtils.getInitialsFromUserNameParts(parts);
    }

    private static String getSanitizedUserName(String userName) {
        return XMLUtils.fixIllegalXmlChars((String)userName.replaceAll(EMAIL_REGEX, "").trim());
    }

    private static String firstCharacterAsUpper(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isLetter(s.charAt(i))) continue;
            return String.valueOf(s.charAt(i)).toUpperCase();
        }
        return UNKNOWN_INITIAL;
    }

    private static String getInitialsFromUserNameParts(String[] parts) {
        int firstPartStartingWithLetter = GeneratedAvatarUtils.getFirstPartStartingWithCharacter(parts);
        int lastPartStartingWithLetter = GeneratedAvatarUtils.getLastPartStartingWithCharacter(parts);
        if (firstPartStartingWithLetter == -1) {
            return UNKNOWN_INITIAL;
        }
        if (firstPartStartingWithLetter == lastPartStartingWithLetter) {
            return GeneratedAvatarUtils.firstCharacterAsUpper(parts[firstPartStartingWithLetter]);
        }
        return GeneratedAvatarUtils.firstCharacterAsUpper(parts[firstPartStartingWithLetter]) + GeneratedAvatarUtils.firstCharacterAsUpper(parts[lastPartStartingWithLetter]);
    }

    private static int getLastPartStartingWithCharacter(String[] parts) {
        return GeneratedAvatarUtils.getPartStartingWithCharacter(IntStream.iterate(parts.length - 1, i -> i - 1), parts);
    }

    private static int getFirstPartStartingWithCharacter(String[] parts) {
        return GeneratedAvatarUtils.getPartStartingWithCharacter(IntStream.iterate(0, i -> i + 1), parts);
    }

    private static int getPartStartingWithCharacter(IntStream searchDirection, String[] parts) {
        return searchDirection.limit(parts.length).filter(i -> parts[i].matches(FIRST_CHAR_LETTER_REGEX)).findFirst().orElse(-1);
    }

    private GeneratedAvatarUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

