/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.user.avatar;

import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.helper.ImageUtil;
import com.teamscale.index.user.AvatarIndex;
import com.teamscale.index.user.EAvatarSize;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.ui.user.avatar.GeneratedAvatarUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import java.io.InputStream;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.resources.ResourceException;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.VisibleForTesting;

@Path(value="api/users/{user}/avatar")
public class UserAvatarService
extends ApiBase {
    private static final String USER_PATH_PARAMETER = "user";
    @VisibleForTesting
    static final String GENERIC_IMAGE = "image/*";

    @GET
    @RequiresNoPermission
    @Operation(summary="Get user avatar image", description="Returns the image file that serves as the avatar for the user in the first path parameter.", tags={"Avatars", "Users"})
    @Cache(maxAge=1)
    @Produces(value={"image/*"})
    public Response getUserAvatar(@PathParam(value="user") String username, @Parameter(description="Controls the least size of the image.", required=true) @QueryParam(value="size") String avatarSize, @Parameter(description="Hash of the avatar to improve caching. Can be set to an arbitrary string but should change when the image has been updated.", required=true) @QueryParam(value="avatar-hash") String avatarHash) throws StorageException {
        if (UserAvatarService.isTeamscaleUser(username)) {
            return Response.ok((Object)UserAvatarService.readTeamscaleImportAvatar()).type("image/svg+xml").build();
        }
        AvatarIndex avatarIndex = (AvatarIndex)this.openGlobalIndex(AvatarIndex.class);
        UserIndex userIndex = (UserIndex)this.openGlobalIndex(UserIndex.class);
        User user = userIndex.getUser(username);
        if (user == null) {
            return UserAvatarService.getOrCreateDefaultAvatar(username, avatarIndex);
        }
        return UserAvatarService.getImage(avatarIndex, username, user, UserAvatarService.getAvatarSize(avatarSize));
    }

    private static boolean isTeamscaleUser(String username) {
        return "Teamscale import".equals(username) || "Teamscale".equals(username);
    }

    @PUT
    @RequiresNoPermission(description="Users can change their own avatar only but admin users can change someone else's avatar")
    @Operation(summary="Update user avatar image", description="Uploads the image file given in the multipart called 'avatar' as the avatar of the user in the first path parameter.", tags={"Avatars", "Users"})
    @Consumes(value={"multipart/form-data"})
    public void updateUserAvatar(@PathParam(value="user") String username, @Parameter(description="User avatar image") @FormDataParam(value="avatar") InputStream uploadedImageInputStream) throws StorageException {
        byte[] avatarPicture;
        if (!this.getUser().getUsername().equals(username)) {
            this.getPermissions().checkBasicPermission(EBasicPermissionScope.USERS, username, EBasicPermission.EDIT);
        }
        try {
            avatarPicture = FileSystemUtils.readStreamBinary((InputStream)uploadedImageInputStream);
        }
        catch (IOException ex) {
            throw new InternalServerErrorException("Could not read uploaded image file", (Throwable)ex);
        }
        if (avatarPicture.length == 0) {
            throw new BadRequestException("No valid image file upload given");
        }
        AvatarIndex avatarIndex = (AvatarIndex)this.openGlobalIndex(AvatarIndex.class);
        try {
            UserAvatarService.updateThumbnail(username, avatarIndex, avatarPicture);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Unable to generate avatar thumbnails.", (Throwable)e);
        }
        this.updateUserAvatarHash(username, avatarIndex.getImage(username, EAvatarSize.ORIGINAL));
    }

    @VisibleForTesting
    static void updateThumbnail(String username, AvatarIndex avatarIndex, byte[] avatarPicture) throws IOException, StorageException {
        UserAvatarService.changeImage(avatarPicture, avatarIndex, username);
    }

    private static void changeImage(byte[] originalImage, AvatarIndex index, String username) throws IOException, StorageException {
        BufferedImage image = ImageUtil.createBufferedImage((byte[])originalImage);
        if (image.getWidth() < EAvatarSize.MAX_SIZE || image.getHeight() < EAvatarSize.MAX_SIZE) {
            double factor = (double)EAvatarSize.MAX_SIZE / (double)Math.min(image.getWidth(), image.getHeight());
            image = Scalr.resize((BufferedImage)image, (int)((int)Math.ceil(factor * (double)image.getWidth())), (int)((int)Math.ceil(factor * (double)image.getHeight())), (BufferedImageOp[])new BufferedImageOp[0]);
            originalImage = ImageUtil.createJpegBytes((BufferedImage)image);
        }
        index.putImage(username, EAvatarSize.ORIGINAL, originalImage);
        UserAvatarService.regenerateThumbnails(image, index, username);
    }

    private static EAvatarSize getAvatarSize(String size) throws BadRequestException {
        EAvatarSize result = (EAvatarSize)EnumUtils.valueOfIgnoreCase(EAvatarSize.class, (String)size);
        if (result == null) {
            throw new BadRequestException("Invalid size given: " + size);
        }
        return result;
    }

    private static Response getImage(AvatarIndex avatarIndex, String username, User user, EAvatarSize size) throws StorageException {
        byte[] image = avatarIndex.getImage(username, size);
        if (image != null) {
            return Response.ok((Object)image).type(GENERIC_IMAGE).build();
        }
        return UserAvatarService.getOrCreateDefaultAvatar(user.getFullName(), avatarIndex);
    }

    private static Response getOrCreateDefaultAvatar(String username, AvatarIndex avatarIndex) throws StorageException {
        byte[] imageBytes = avatarIndex.getDefaultImage(username);
        if (imageBytes == null) {
            imageBytes = GeneratedAvatarUtils.generateSvgAvatar(username);
            avatarIndex.putDefaultImage(username, imageBytes);
        }
        return Response.ok((Object)imageBytes).type("image/svg+xml").build();
    }

    private static byte[] readTeamscaleImportAvatar() {
        if (!Resource.exists(UserAvatarService.class, (String)"teamscale-import-avatar.svg")) {
            throw new InternalServerErrorException("Could not locate default avatar");
        }
        try {
            return Resource.of(UserAvatarService.class, (String)"teamscale-import-avatar.svg").getAsByteArray();
        }
        catch (ResourceException e) {
            throw new InternalServerErrorException("Failed to read default avatar", (Throwable)e);
        }
    }

    private static void regenerateThumbnails(BufferedImage image, AvatarIndex index, String username) throws IOException, StorageException {
        image = ImageUtil.convertToRGB((BufferedImage)image);
        for (EAvatarSize size : EAvatarSize.values()) {
            if (!size.isThumbnail()) continue;
            BufferedImage scaledImage = Scalr.resize((BufferedImage)image, (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)size.getSize(), (BufferedImageOp[])new BufferedImageOp[0]);
            index.putImage(username, size, ImageUtil.createJpegBytes((BufferedImage)scaledImage));
        }
    }

    private void updateUserAvatarHash(String username, byte[] imageBytes) throws StorageException {
        UserIndex userIndex = (UserIndex)this.openGlobalIndex(UserIndex.class);
        User user = userIndex.getUser(username);
        if (user == null) {
            return;
        }
        String hash = Long.toHexString(XXHashUtils.xxhash64((byte[])imageBytes));
        user.setAvatarHash(hash);
        userIndex.setUser(user, this.serviceInfo.getMessageBroker());
    }
}

