/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.base;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.util.CheckUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.conqat.lib.commons.string.StringUtils;

public abstract class HardCodedLiteralsCheckBase
extends CheckImplementationBase {
    private static final EnumSet<ETokenType> BOOLEAN_OPERATORS = EnumSet.of(ETokenType.AND, ETokenType.OR, ETokenType.NOT, ETokenType.EQUIV);
    private static final EnumSet<ETokenType> DATA_VALUE_DEFINITIONS = EnumSet.of(ETokenType.CLASS_DATA, ETokenType.CONSTANTS, ETokenType.DATA, ETokenType.STATICS, ETokenType.TYPES);
    protected List<IToken> preprocessedTokens;
    private List<IToken> tokensBetweenBraces;
    private Pattern literalPattern;

    @Override
    public void execute() throws CheckException {
        this.buildLiteralPattern();
        for (ShallowEntity entity : this.context.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED)) {
            this.preprocessedTokens = entity.includedTokens();
            this.tokensBetweenBraces = null;
            List<IToken> characterLiterals = this.preprocessedTokens.stream().filter(token -> CheckUtils.STRING_LITERALS.contains((Object)token.getType())).toList();
            for (IToken literal : characterLiterals) {
                this.checkCharacterLiteral(literal);
            }
        }
    }

    private void buildLiteralPattern() {
        String regex = this.getLiteralRegex();
        if (StringUtils.isEmpty((String)regex)) {
            this.literalPattern = null;
            return;
        }
        this.literalPattern = Pattern.compile(regex);
    }

    private void checkCharacterLiteral(IToken literal) throws CheckException {
        if (!this.isMatchingLiteral(literal)) {
            return;
        }
        if (this.findAllMatchingLiteral()) {
            this.createFindingForLiteral(literal);
            return;
        }
        Optional<IToken> identifier = this.lookupIdentifier(literal);
        if (identifier.isPresent() && this.isMatchingIdentifier(identifier.get())) {
            this.createFindingForLiteral(literal);
        }
    }

    private Optional<IToken> lookupIdentifier(IToken literal) throws CheckException {
        Optional<IToken> identifier = this.languageSpecificLookup(literal);
        if (identifier.isEmpty()) {
            identifier = this.lookupIdentifierIfInOperation(literal, true);
        }
        if (identifier.isEmpty()) {
            identifier = this.lookupIdentifierIfInOperation(literal, false);
        }
        return identifier;
    }

    private Optional<IToken> languageSpecificLookup(IToken literal) throws CheckException {
        switch (literal.getLanguage()) {
            case ABAP: {
                Optional<IToken> identifier = this.lookupIdentifierIfInConditionalBlock(literal);
                if (identifier.isPresent()) {
                    return identifier;
                }
            }
            case VB: {
                return this.lookupIdentifierIfInDefinition(literal);
            }
            case CS: {
                Optional<IToken> identifier = this.lookupIdentifierIfInProperty(literal);
                if (identifier.isPresent()) {
                    return identifier;
                }
            }
            case JAVA: 
            case CPP: 
            case CPP_MS_CLI: 
            case GOSU: 
            case JAVASCRIPT: {
                return this.lookupIdentifierIfInNewStatement(literal);
            }
            case GO: {
                return this.lookupIdentifierInGoDeclaration(literal);
            }
            case C: 
            case ESQL: 
            case KOTLIN: 
            case GROOVY: 
            case XTEND: 
            case SWIFT: 
            case PHP: 
            case PYTHON: 
            case RUST: {
                return Optional.empty();
            }
        }
        throw new CheckException("Language " + String.valueOf(literal.getLanguage()) + " of " + String.valueOf(literal) + " not supported.");
    }

    private Optional<IToken> lookupIdentifierInGoDeclaration(IToken literal) {
        int indexOfLiteral = this.preprocessedTokens.indexOf(literal);
        int identifierIndex = indexOfLiteral - 3;
        if (identifierIndex >= 0 && TokenStreamUtils.startsWith(this.preprocessedTokens.subList(identifierIndex, indexOfLiteral + 1), ETokenType.IDENTIFIER, ETokenType.STRING, ETokenType.EQ, ETokenType.STRING_LITERAL)) {
            IToken identifier = this.preprocessedTokens.get(identifierIndex);
            return Optional.of(identifier);
        }
        return Optional.empty();
    }

    protected void createFindingForLiteral(IToken literal) throws CheckException {
        this.buildFinding(this.getFindingsMessageText() + " " + literal.getText().replace("'", "`"), this.buildLocation().forToken(literal)).createAndStore();
    }

    private boolean isMatchingLiteral(IToken literal) {
        if (this.literalPattern == null) {
            return true;
        }
        return this.literalPattern.matcher(CheckUtils.getUnquotedTextForCharacterLiteral(literal)).matches();
    }

    protected boolean findAllMatchingLiteral() {
        return false;
    }

    private Optional<IToken> lookupIdentifierIfInOperation(IToken literal, boolean leftHandLookup) {
        int literalIndex;
        int operatorIndex;
        int identifierIndex;
        int lookupDirection = 1;
        if (leftHandLookup) {
            lookupDirection = -1;
        }
        if (this.isFieldSymbolAt(identifierIndex = (operatorIndex = (literalIndex = this.preprocessedTokens.indexOf(literal)) + lookupDirection) + lookupDirection)) {
            identifierIndex += lookupDirection;
        }
        if (identifierIndex >= 0 && identifierIndex < this.preprocessedTokens.size() && HardCodedLiteralsCheckBase.isOperatorOrLParan(this.preprocessedTokens.get(operatorIndex)) && this.preprocessedTokens.get(identifierIndex).getType().isIdentifier()) {
            return Optional.of(this.preprocessedTokens.get(identifierIndex));
        }
        if (literal.getLanguage() == ELanguage.ABAP && identifierIndex >= 0 && this.isStartOfStatement(identifierIndex)) {
            return Optional.empty();
        }
        if ((literal.getLanguage() == ELanguage.PYTHON || literal.getLanguage() == ELanguage.GO) && TokenStreamUtils.contains(this.preprocessedTokens, ETokenType.IDENTIFIER) && this.isInBraces(identifierIndex)) {
            return Optional.of(this.preprocessedTokens.get(identifierIndex));
        }
        if (leftHandLookup && identifierIndex >= 2 && this.preprocessedTokens.get(identifierIndex -= 2).getType().isIdentifier()) {
            return Optional.of(this.preprocessedTokens.get(identifierIndex));
        }
        return Optional.empty();
    }

    private boolean isInBraces(int identifierIndex) {
        if (this.tokensBetweenBraces == null) {
            this.tokensBetweenBraces = TokenStreamUtils.tokensBetweenWithNesting(this.preprocessedTokens, ETokenType.LBRACE, ETokenType.RBRACE);
        }
        if (this.tokensBetweenBraces.isEmpty()) {
            return false;
        }
        IToken firstTokenInsideBraces = this.tokensBetweenBraces.getFirst();
        IToken lastTokenInsideBraces = this.tokensBetweenBraces.getLast();
        IToken identifierToken = this.preprocessedTokens.get(identifierIndex);
        return firstTokenInsideBraces.getOffset() <= identifierToken.getOffset() && identifierToken.getOffset() <= lastTokenInsideBraces.getOffset();
    }

    private boolean isStartOfStatement(int index) {
        return index == 0 || this.preprocessedTokens.get(index - 1).getType() == ETokenType.DOT;
    }

    private static boolean isOperatorOrLParan(IToken token) {
        ETokenType tokenType = token.getType();
        return !BOOLEAN_OPERATORS.contains(tokenType) && tokenType.isOperator() || tokenType == ETokenType.LPAREN;
    }

    private boolean isFieldSymbolAt(int pos) {
        if (pos < 1 || pos >= this.preprocessedTokens.size() - 1) {
            return false;
        }
        IToken token = this.preprocessedTokens.get(pos);
        if (token.getType() == ETokenType.LT) {
            ++pos;
        } else if (token.getType() == ETokenType.GT) {
            --pos;
        }
        IToken tokenBefore = this.preprocessedTokens.get(pos - 1);
        IToken tokenAfter = this.preprocessedTokens.get(pos + 1);
        return tokenBefore.getType() == ETokenType.LT && tokenAfter.getType() == ETokenType.GT;
    }

    private Optional<IToken> lookupIdentifierIfInConditionalBlock(IToken literal) {
        Optional<IToken> identifier = this.lookupIdentifierIfInCaseWhen(literal);
        if (identifier.isEmpty()) {
            identifier = this.lookupIdentifierIfInSwitchWhen(literal);
        }
        return identifier;
    }

    private Optional<IToken> lookupIdentifierIfInSwitchWhen(IToken literal) {
        int literalIndex = this.preprocessedTokens.indexOf(literal);
        if (literalIndex < 1 || this.preprocessedTokens.get(literalIndex - 1).getType() != ETokenType.WHEN) {
            return Optional.empty();
        }
        for (int currentIndex = literalIndex - 1; currentIndex >= 0; --currentIndex) {
            if (this.preprocessedTokens.get(currentIndex).getType() != ETokenType.SWITCH || currentIndex >= this.preprocessedTokens.size() - 3) continue;
            IToken switchOperand = this.preprocessedTokens.get(currentIndex + 3);
            if (switchOperand.getType().isIdentifier()) {
                return Optional.of(switchOperand);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private Optional<IToken> lookupIdentifierIfInCaseWhen(IToken literal) {
        int literalIndex = this.preprocessedTokens.indexOf(literal);
        if (literalIndex < 1 || this.preprocessedTokens.get(literalIndex - 1).getType() != ETokenType.WHEN) {
            return Optional.empty();
        }
        for (int currentIndex = literalIndex - 1; currentIndex >= 0; --currentIndex) {
            if (this.preprocessedTokens.get(currentIndex).getType() != ETokenType.CASE) continue;
            IToken caseControlIdentifier = this.preprocessedTokens.get(currentIndex + 1);
            if (caseControlIdentifier.getType() == ETokenType.LOWER) {
                caseControlIdentifier = this.preprocessedTokens.get(currentIndex + 2);
            }
            if (caseControlIdentifier.getType().isIdentifier()) {
                return Optional.of(caseControlIdentifier);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private Optional<IToken> lookupIdentifierIfInDefinition(IToken literal) {
        int literalIndex = this.preprocessedTokens.indexOf(literal);
        if (literalIndex < 1 || this.preprocessedTokens.get(literalIndex - 1).getType() != ETokenType.VALUE) {
            return Optional.empty();
        }
        for (int currentIndex = literalIndex - 1; currentIndex >= 0; --currentIndex) {
            ETokenType currentTokenType = this.preprocessedTokens.get(currentIndex).getType();
            if (this.isStartOfStatement(currentIndex) && DATA_VALUE_DEFINITIONS.contains(currentTokenType)) {
                return Optional.of(this.preprocessedTokens.get(currentIndex + 1));
            }
            if (currentTokenType != ETokenType.DOT) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private Optional<IToken> lookupIdentifierIfInProperty(IToken literal) {
        int literalIndex = this.preprocessedTokens.indexOf(literal);
        if (literalIndex < 1 || this.preprocessedTokens.get(literalIndex - 1).getType() != ETokenType.RETURN) {
            return Optional.empty();
        }
        for (int currentIndex = literalIndex - 1; currentIndex >= 0; --currentIndex) {
            ETokenType currentTokenType = this.preprocessedTokens.get(currentIndex).getType();
            if (currentTokenType != ETokenType.GET) continue;
            return Optional.of(this.preprocessedTokens.get(currentIndex - 2));
        }
        return Optional.empty();
    }

    private Optional<IToken> lookupIdentifierIfInNewStatement(IToken literal) {
        int literalIndex = this.preprocessedTokens.indexOf(literal);
        if (literalIndex < 4 || this.preprocessedTokens.get(literalIndex - 3).getType() != ETokenType.NEW) {
            return Optional.empty();
        }
        IToken identifier = this.preprocessedTokens.get(literalIndex - 5);
        if (identifier.getType() == ETokenType.IDENTIFIER) {
            return Optional.of(identifier);
        }
        return Optional.empty();
    }

    protected abstract String getLiteralRegex();

    protected abstract boolean isMatchingIdentifier(IToken var1);

    protected abstract String getFindingsMessageText();
}

