/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.base.string_interpolation;

import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class MessageFormatUtils {
    public static String removeEscapedFromMessageFormatString(String messageFormatString) {
        StringBuilder builder = new StringBuilder(messageFormatString.length());
        MessageFormatState state = MessageFormatState.UNESCAPED;
        for (int i = 0; i < messageFormatString.length(); ++i) {
            char c = messageFormatString.charAt(i);
            if ((state = MessageFormatUtils.getStateAfter(state, c)) != MessageFormatState.UNESCAPED) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    private static MessageFormatState getStateAfter(MessageFormatState state, char c) {
        if (c == '\'') {
            switch (state.ordinal()) {
                case 1: {
                    state = MessageFormatState.UNESCAPED_QUOTE;
                    break;
                }
                case 3: {
                    state = MessageFormatState.UNESCAPED;
                    break;
                }
                case 0: {
                    state = MessageFormatState.ESCAPED_QUOTE;
                    break;
                }
                case 2: {
                    state = MessageFormatState.ESCAPED;
                    break;
                }
                default: {
                    CCSMAssert.fail((String)"invalid state");
                    break;
                }
            }
        } else {
            switch (state.ordinal()) {
                case 1: 
                case 2: {
                    state = MessageFormatState.UNESCAPED;
                    break;
                }
                case 0: 
                case 3: {
                    state = MessageFormatState.ESCAPED;
                    break;
                }
                default: {
                    CCSMAssert.fail((String)"invalid state");
                }
            }
        }
        return state;
    }

    private MessageFormatUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    private static enum MessageFormatState {
        ESCAPED,
        UNESCAPED,
        ESCAPED_QUOTE,
        UNESCAPED_QUOTE;

    }
}

