/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class SubRecognizer<STATE extends Enum<STATE>>
extends RecognizerBase<STATE> {
    private final RecognizerBase<STATE> subRecognizer;
    private final int minRepetitions;
    private final int maxRepetitions;

    public SubRecognizer(RecognizerBase<STATE> subRecognizer, int minRepetitions, int maxRepetitions) {
        CCSMAssert.isTrue((minRepetitions >= 0 ? 1 : 0) != 0, (String)"Minimal number of repetitions must not be negative!");
        CCSMAssert.isTrue((maxRepetitions > 0 ? 1 : 0) != 0, (String)"Maximal number of repetitions must be positive!");
        CCSMAssert.isTrue((minRepetitions <= maxRepetitions ? 1 : 0) != 0, (String)"Minimal number of repetitions must not be larger than maximal number!");
        this.subRecognizer = subRecognizer;
        this.minRepetitions = minRepetitions;
        this.maxRepetitions = maxRepetitions;
    }

    @Override
    protected int matchesLocally(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
        int currentOffset = startOffset;
        for (int numMatches = 0; numMatches < this.maxRepetitions; ++numMatches) {
            int newOffset = this.subRecognizer.matches(parserState, tokens, currentOffset);
            if (newOffset == currentOffset && newOffset == tokens.size()) {
                return newOffset;
            }
            if (newOffset == -1 || newOffset == currentOffset) {
                if (numMatches >= this.minRepetitions) {
                    return currentOffset;
                }
                return -1;
            }
            currentOffset = newOffset;
        }
        return currentOffset;
    }

    @Override
    protected String getRecognizerStringRepresentation() {
        return super.getRecognizerStringRepresentation() + "[" + this.subRecognizer.toString() + "]";
    }
}

