/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.abap;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.abap.ModuleBlockStartRecognizer;
import eu.cqse.check.framework.shallowparser.languages.abap.SingleSelectRecognizer;

public class AbapShallowParser
extends ShallowParserBase<EAbapParserStates> {
    public static final ITokenMatcher IDENTIFIER_LIKE = ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.KEYWORD, ETokenType.ETokenClass.OPERATOR});
    private static final ITokenMatcher SIMPLE_STATEMENT_START_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ADD, ETokenType.ADD_CORRESPONDING, ETokenType.APPEND, ETokenType.ASSERT, ETokenType.ASSIGN, ETokenType.AUTHORITY_CHECK, ETokenType.BACK, ETokenType.BREAK_POINT, ETokenType.CALL, ETokenType.CASE, ETokenType.CHECK, ETokenType.CLEAR, ETokenType.CLOSE, ETokenType.COLLECT, ETokenType.COMMIT, ETokenType.COMMUNICATION, ETokenType.COMPUTE, ETokenType.CONCATENATE, ETokenType.CONDENSE, ETokenType.CONSTANTS, ETokenType.CONTEXTS, ETokenType.CONTINUE, ETokenType.CONTROLS, ETokenType.CONVERT, ETokenType.CREATE, ETokenType.DATA, ETokenType.DELETE, ETokenType.DEMAND, ETokenType.DESCRIBE, ETokenType.DETAIL, ETokenType.DIVIDE, ETokenType.DIVIDE_CORRESPONDING, ETokenType.DO, ETokenType.EDITOR_CALL, ETokenType.ENHANCEMENT_POINT, ETokenType.EXISTS, ETokenType.EXIT, ETokenType.EXPORT, ETokenType.EXTRACT, ETokenType.FETCH, ETokenType.FIELDS, ETokenType.FIELD_GROUPS, ETokenType.FIELD_SYMBOLS, ETokenType.FIND, ETokenType.FORMAT, ETokenType.FREE, ETokenType.GENERATE, ETokenType.GET, ETokenType.HIDE, ETokenType.IDENTIFIER, ETokenType.IF, ETokenType.IMPORT, ETokenType.INCLUDE, ETokenType.INFOTYPES, ETokenType.INPUT, ETokenType.INSERT, ETokenType.LEAVE, ETokenType.LOAD, ETokenType.LOCAL, ETokenType.LOG_POINT, ETokenType.MAXIMUM, ETokenType.MESSAGE, ETokenType.MINIMUM, ETokenType.MODIFY, ETokenType.MODULE, ETokenType.MOVE, ETokenType.MOVE_CORRESPONDING, ETokenType.MULTIPLY_CORRESPONDING, ETokenType.MULTIPLY, ETokenType.NAME, ETokenType.NEW_LINE, ETokenType.NEW_PAGE, ETokenType.NEW_SECTION, ETokenType.OPEN, ETokenType.OVERLAY, ETokenType.PACK, ETokenType.PACKAGE, ETokenType.PARAMETERS, ETokenType.PERFORM, ETokenType.POSITION, ETokenType.PRINT_CONTROL, ETokenType.PUT, ETokenType.RAISE, ETokenType.RANGES, ETokenType.READ, ETokenType.REFRESH, ETokenType.REJECT, ETokenType.REPLACE, ETokenType.RESERVE, ETokenType.RESUME, ETokenType.RETURN, ETokenType.ROLLBACK, ETokenType.SCROLL, ETokenType.SEARCH, ETokenType.SET, ETokenType.SHIFT, ETokenType.SKIP, ETokenType.SORT, ETokenType.SPLIT, ETokenType.STATICS, ETokenType.STOP, ETokenType.SUBMIT, ETokenType.SUBTRACT, ETokenType.SUBTRACT_CORRESPONDING, ETokenType.SUM, ETokenType.SUMMARY, ETokenType.SUMMING, ETokenType.SUPPLY, ETokenType.SUPPRESS, ETokenType.SYNTAX_CHECK, ETokenType.TRANSFER, ETokenType.TRANSLATE, ETokenType.TRUNCATE, ETokenType.TYPES, ETokenType.ULINE, ETokenType.UNASSIGN, ETokenType.UNPACK, ETokenType.UPDATE, ETokenType.VERSION, ETokenType.WAIT, ETokenType.WINDOW, ETokenType.WRITE, ETokenType.NEW});
    public static final ITokenMatcher INCLUDE_FILTER_TOKEN_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRUCTURE, ETokenType.TYPE});
    private static final ITokenMatcher EVENT_BLOCKS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INITIALIZATION, ETokenType.START_OF_SELECTION, ETokenType.END_OF_SELECTION, ETokenType.TOP_OF_PAGE, ETokenType.END_OF_PAGE, ETokenType.LOAD_OF_PROGRAM});
    private static final ITokenMatcher EVENT_BLOCKS_END = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.AT, ETokenType.FORM, ETokenType.CLASS, ETokenType.INTERFACE}).or(new ITokenMatcher[]{EVENT_BLOCKS});

    public AbapShallowParser() {
        super(EAbapParserStates.class, EAbapParserStates.TOPLEVEL);
        this.createMetaRules();
        this.createTopLevelRules();
        this.createTypeRules();
        this.createAttributeRules();
        this.createMethodRules();
        this.createModuleRules();
        this.createStatementRules();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.DOT}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
    }

    private void createTopLevelRules() {
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.REPORT, ETokenType.PROGRAM})).optional(new ITokenMatcher[]{ETokenType.COLON}).sequence(IDENTIFIER_LIKE).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText(), INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntilOrEof(EAbapParserStates.IN_TYPE);
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.SELECTION_SCREEN}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        RecognizerBase<EAbapParserStates> topsRecognizer = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.TOP_OF_PAGE, ETokenType.DURING, ETokenType.LINE_SELECTION}).createNode(EShallowEntityType.METHOD, "top-of-page during line-selection").skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntilOrEof(EAbapParserStates.STATEMENTS);
        AbapShallowParser.endMethodEntityOnEventBlock(topsRecognizer);
        RecognizerBase<EAbapParserStates> eventBlockRecognizer = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.IN_TYPE}).sequence(EVENT_BLOCKS).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntilOrEof(EAbapParserStates.STATEMENTS);
        AbapShallowParser.endMethodEntityOnEventBlock(eventBlockRecognizer);
        this.createGetBlockRules();
        this.createAtBlockRules();
    }

    private void createGetBlockRules() {
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.GET, ETokenType.ETokenClass.KEYWORD}).createNode(EShallowEntityType.STATEMENT, INameResolver.ofIndices(0, 1)).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        RecognizerBase<EAbapParserStates> getLateEventBlockRecognizer = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.GET, ETokenType.IDENTIFIER, ETokenType.LATE}).createNode(EShallowEntityType.METHOD, "get late", INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntilOrEof(EAbapParserStates.STATEMENTS);
        AbapShallowParser.endMethodEntityOnEventBlock(getLateEventBlockRecognizer);
        RecognizerBase<EAbapParserStates> getEventBlockRecognizer = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.GET, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntilOrEof(EAbapParserStates.STATEMENTS);
        AbapShallowParser.endMethodEntityOnEventBlock(getEventBlockRecognizer);
    }

    private void createAtBlockRules() {
        RecognizerBase<EAbapParserStates> selectionScreenBlockRecognizer = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.AT, ETokenType.SELECTION_SCREEN}).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).createNode(EShallowEntityType.METHOD, "at selection-screen", INameResolver.ofRange(0, -2, " ")).parseUntilOrEof(EAbapParserStates.STATEMENTS);
        AbapShallowParser.endMethodEntityOnEventBlock(selectionScreenBlockRecognizer);
        RecognizerBase<EAbapParserStates> atPfBlockRecognizer = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.AT, ETokenType.PF_EVENT}).createNode(EShallowEntityType.METHOD, "pf event", INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntilOrEof(EAbapParserStates.STATEMENTS);
        AbapShallowParser.endMethodEntityOnEventBlock(atPfBlockRecognizer);
        RecognizerBase<EAbapParserStates> atEventBlockRecognizer = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.AT, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LINE_SELECTION, ETokenType.USER_COMMAND})}).createNode(EShallowEntityType.METHOD, INameResolver.ofIndices(0, 1)).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntilOrEof(EAbapParserStates.STATEMENTS);
        AbapShallowParser.endMethodEntityOnEventBlock(atEventBlockRecognizer);
    }

    private static void endMethodEntityOnEventBlock(RecognizerBase<EAbapParserStates> eventBlockRecognizer) {
        eventBlockRecognizer.sequenceBefore(EVENT_BLOCKS_END).endNode();
        eventBlockRecognizer.sequenceBefore(new ITokenMatcher[]{ETokenType.GET, ETokenType.IDENTIFIER}).endNode();
        eventBlockRecognizer.preCondition(new ModuleBlockStartRecognizer()).endNode();
    }

    private void createMetaRules() {
        this.inState(new EAbapParserStates[]{EAbapParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PROTECTED, ETokenType.PRIVATE}), ETokenType.SECTION, ETokenType.DOT}).createNode(EShallowEntityType.META, "Visibility", INameResolver.firstMatchedTokenText()).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TYPE_POOLS, ETokenType.TABLES}), ETokenType.COLON, IDENTIFIER_LIKE}).createNode(EShallowEntityType.META, INameResolver.ofIndex(-3), INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.inAnyState().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TYPE_POOLS, ETokenType.TABLES}), IDENTIFIER_LIKE).createNode(EShallowEntityType.META, INameResolver.ofIndex(-2), INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.DEFINE}).createNode(EShallowEntityType.META, "macro").skipAfter(new ITokenMatcher[]{ETokenType.END_OF_DEFINITION, ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.DECLARATIONS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INTERFACES, ETokenType.ALIASES})).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.INCLUDE}).notPreCondition(this.createRecognizer(start -> start.sequence(INCLUDE_FILTER_TOKEN_TYPES))).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
    }

    private void createTypeRules() {
        this.createClassRules();
        RecognizerBase interfaceAlternative = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.INTERFACE, ETokenType.IDENTIFIER});
        interfaceAlternative.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LOAD, ETokenType.DEFERRED, ETokenType.LOCAL})).createNode(EShallowEntityType.TYPE, "interface publication", INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        interfaceAlternative.createNode(EShallowEntityType.TYPE, "interface definition", INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.DECLARATIONS).sequence(new ITokenMatcher[]{ETokenType.ENDINTERFACE, ETokenType.DOT}).endNode();
    }

    private void createClassRules() {
        RecognizerBase classDefinitionAlternative = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.DECLARATIONS, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.CLASS, ETokenType.IDENTIFIER, ETokenType.DEFINITION});
        classDefinitionAlternative.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LOAD, ETokenType.DEFERRED, ETokenType.LOCAL})).createNode(EShallowEntityType.TYPE, "class publication", INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        classDefinitionAlternative.createNode(EShallowEntityType.TYPE, "class definition", INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.DECLARATIONS).sequence(new ITokenMatcher[]{ETokenType.ENDCLASS, ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.DECLARATIONS, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.CLASS, ETokenType.IDENTIFIER, ETokenType.IMPLEMENTATION}).createNode(EShallowEntityType.TYPE, "class implementation", INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.DECLARATIONS).sequence(new ITokenMatcher[]{ETokenType.ENDCLASS, ETokenType.DOT}).endNode();
    }

    private void createAttributeRules() {
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.DECLARATIONS, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.DATA, ETokenType.BEGIN, ETokenType.OF, ETokenType.COMMON, ETokenType.PART}).optional(IDENTIFIER_LIKE).createNode(EShallowEntityType.ATTRIBUTE, INameResolver.firstMatchedTokenText(), INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.END, ETokenType.OF, ETokenType.COMMON, ETokenType.PART}).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.DECLARATIONS, EAbapParserStates.IN_TYPE}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TYPES, ETokenType.CONSTANTS, ETokenType.DATA, ETokenType.STATICS, ETokenType.CLASS_DATA})).optional(new ITokenMatcher[]{ETokenType.COLON}).sequence(new ITokenMatcher[]{ETokenType.BEGIN, ETokenType.OF, IDENTIFIER_LIKE}).createNode(EShallowEntityType.ATTRIBUTE, INameResolver.firstMatchedTokenText(), INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.END, ETokenType.OF}).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.DECLARATIONS, EAbapParserStates.IN_TYPE}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EVENTS, ETokenType.CLASS_EVENTS})).createNode(EShallowEntityType.ATTRIBUTE, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.DECLARATIONS, EAbapParserStates.IN_TYPE}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CONSTANTS, ETokenType.NODES, ETokenType.STATICS, ETokenType.DATA, ETokenType.TYPES, ETokenType.FIELD_GROUPS, ETokenType.CLASS_DATA, ETokenType.RANGES, ETokenType.SELECT_OPTIONS})).optional(new ITokenMatcher[]{ETokenType.COLON}).sequence(IDENTIFIER_LIKE).createNode(EShallowEntityType.ATTRIBUTE, INameResolver.firstMatchedTokenText(), INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.DECLARATIONS, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.INFOTYPES}).optional(new ITokenMatcher[]{ETokenType.COLON}).sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL}).createNode(EShallowEntityType.ATTRIBUTE, INameResolver.firstMatchedTokenText(), INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.DECLARATIONS, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.FIELD_SYMBOLS}).optional(new ITokenMatcher[]{ETokenType.COLON}).sequence(new ITokenMatcher[]{ETokenType.LT, IDENTIFIER_LIKE}).createNode(EShallowEntityType.ATTRIBUTE, INameResolver.firstMatchedTokenText(), INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.DECLARATIONS, EAbapParserStates.IN_TYPE}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PARAMETER, ETokenType.PARAMETERS})).optional(new ITokenMatcher[]{ETokenType.COLON}).sequence(IDENTIFIER_LIKE).createNode(EShallowEntityType.ATTRIBUTE, "parameters", INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
    }

    private void createMethodRules() {
        this.inState(new EAbapParserStates[]{EAbapParserStates.DECLARATIONS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.METHODS, ETokenType.CLASS_METHODS})).skipForward(1).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ABSTRACT, ETokenType.DOT, ETokenType.RETURNING, ETokenType.IMPORTING, ETokenType.EXPORTING, ETokenType.REDEFINITION, ETokenType.CHANGING, ETokenType.EXCEPTIONS, ETokenType.RAISING, ETokenType.DEFAULT, ETokenType.FINAL, ETokenType.FOR})).createNode(EShallowEntityType.METHOD, "method declaration", INameResolver.ofRange(1, -1)).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        RecognizerBase<EAbapParserStates> methodImplementation = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.DECLARATIONS, EAbapParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.METHOD}).optional(new ITokenMatcher[]{ETokenType.COLON}).markStart().skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.BY})).createNode(EShallowEntityType.METHOD, "method implementation", INameResolver.ofRange(0, -1)).skipAfter(new ITokenMatcher[]{ETokenType.DOT});
        methodImplementation.sequence(new ITokenMatcher[]{ETokenType.AMDP, ETokenType.ENDMETHOD, ETokenType.DOT}).endNode();
        methodImplementation.parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDMETHOD, ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.FORM}).optional(new ITokenMatcher[]{ETokenType.COLON}).sequence(IDENTIFIER_LIKE).createNode(EShallowEntityType.METHOD, "form", INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDFORM, ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).optional(new ITokenMatcher[]{ETokenType.COLON}).markStart().skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.IMPORTING, ETokenType.EXPORTING, ETokenType.TABLES, ETokenType.CHANGING, ETokenType.RAISING, ETokenType.EXCEPTIONS})).createNode(EShallowEntityType.METHOD, "function", INameResolver.ofRange(0, -1)).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDFUNCTION, ETokenType.DOT}).endNode();
        RecognizerBase<EAbapParserStates> toplevelStartOfSelection = this.inState(new EAbapParserStates[]{EAbapParserStates.IN_TYPE}).sequenceBefore(EVENT_BLOCKS_END.negated()).sequenceBefore(ETokenType.MODULE.negated()).createNode(EShallowEntityType.METHOD, "start-of-selection", "start-of-selection").parseUntilOrEof(EAbapParserStates.STATEMENTS);
        AbapShallowParser.endMethodEntityOnEventBlock(toplevelStartOfSelection);
        RecognizerBase<EAbapParserStates> toplevelStartOfSelectionWithModule = this.inState(new EAbapParserStates[]{EAbapParserStates.IN_TYPE}).sequenceBefore(new ITokenMatcher[]{ETokenType.MODULE}).notPreCondition(new ModuleBlockStartRecognizer()).createNode(EShallowEntityType.METHOD, "start-of-selection", "start-of-selection").parseUntilOrEof(EAbapParserStates.STATEMENTS);
        AbapShallowParser.endMethodEntityOnEventBlock(toplevelStartOfSelectionWithModule);
    }

    private void createModuleRules() {
        RecognizerBase<EAbapParserStates> moduleRecognizer = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.IN_TYPE}).preCondition(new ModuleBlockStartRecognizer()).sequence(new ITokenMatcher[]{ETokenType.MODULE}).markStart().skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INPUT, ETokenType.OUTPUT, ETokenType.DOT}));
        moduleRecognizer.sequence(new ITokenMatcher[]{ETokenType.INPUT, ETokenType.DOT}).createNode(EShallowEntityType.METHOD, "module input", INameResolver.firstMatchedTokenText()).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDMODULE, ETokenType.DOT}).endNode();
        moduleRecognizer.sequence(new ITokenMatcher[]{ETokenType.OUTPUT, ETokenType.DOT}).createNode(EShallowEntityType.METHOD, "module output", INameResolver.firstMatchedTokenText()).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDMODULE, ETokenType.DOT}).endNode();
        moduleRecognizer.sequence(new ITokenMatcher[]{ETokenType.DOT}).createNode(EShallowEntityType.METHOD, "module input", INameResolver.firstMatchedTokenText()).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDMODULE, ETokenType.DOT}).endNode();
    }

    private void createStatementRules() {
        this.inState(new EAbapParserStates[]{EAbapParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.ETokenClass.KEYWORD, ETokenType.EQ}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.createConditionalStatementRules();
        RecognizerBase<EAbapParserStates> changeAlternative = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.ON, ETokenType.CHANGE, ETokenType.OF}).createNode(EShallowEntityType.STATEMENT, "on change").skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.ENDON}));
        changeAlternative.sequence(new ITokenMatcher[]{ETokenType.ENDON, ETokenType.DOT}).endNode();
        changeAlternative.endNodeWithContinuation();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{IDENTIFIER_LIKE, ETokenType.LPAREN}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.createLoopStatementRules();
        RecognizerBase<EAbapParserStates> tryAlternative = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TRY, ETokenType.CATCH, ETokenType.CLEANUP})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ENDTRY, ETokenType.CATCH, ETokenType.ENDCATCH, ETokenType.CLEANUP}));
        tryAlternative.sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ENDTRY, ETokenType.ENDCATCH}), ETokenType.DOT}).endNode();
        tryAlternative.endNodeWithContinuation();
        this.createSelectRules();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.EXEC, ETokenType.SQL}).createNode(EShallowEntityType.STATEMENT, "native SQL").skipAfter(new ITokenMatcher[]{ETokenType.ENDEXEC, ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.READ, ETokenType.MODIFY, ETokenType.COMMIT, ETokenType.ROLLBACK}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ENTITY, ETokenType.ENTITIES})).createNode(EShallowEntityType.STATEMENT, "EML statement").skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.LT}).createNode(EShallowEntityType.STATEMENT, INameResolver.ofRange(0, 2)).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TYPES, ETokenType.CONSTANTS, ETokenType.DATA, ETokenType.STATICS})).optional(new ITokenMatcher[]{ETokenType.COLON}).sequence(new ITokenMatcher[]{ETokenType.BEGIN, ETokenType.OF, IDENTIFIER_LIKE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText(), INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.END, ETokenType.OF}).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(SIMPLE_STATEMENT_START_TOKENS).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
    }

    private void createConditionalStatementRules() {
        RecognizerBase<EAbapParserStates> ifAlternative = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.ELSEIF})).sequenceBefore(ETokenType.ARROW.negated()).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSEIF, ETokenType.ELSE, ETokenType.ENDIF}));
        ifAlternative.sequence(new ITokenMatcher[]{ETokenType.ENDIF, ETokenType.DOT}).endNode();
        ifAlternative.endNodeWithContinuation();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.ELSE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ENDIF, ETokenType.ENDON}), ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.CASE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDCASE, ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.WHEN}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
    }

    private void createLoopStatementRules() {
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.LOOP}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDLOOP, ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.DO}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDDO, ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.WHILE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDWHILE, ETokenType.DOT}).endNode();
        this.inState(new EAbapParserStates[]{EAbapParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.AT}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDAT, ETokenType.DOT}).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.PROVIDE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDPROVIDE, ETokenType.DOT}).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.ENHANCEMENT}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDENHANCEMENT, ETokenType.DOT}).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.ENHANCEMENT_SECTION}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END_ENHANCEMENT_SECTION, ETokenType.DOT}).endNode();
    }

    private void createSelectRules() {
        RecognizerBase<EAbapParserStates> selectAlternative = this.inState(new EAbapParserStates[]{EAbapParserStates.TOPLEVEL, EAbapParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.SELECT});
        selectAlternative.sequence(new ITokenMatcher[]{ETokenType.LPAREN}).createNode(EShallowEntityType.STATEMENT, "method call").skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).skipAfter(new ITokenMatcher[]{ETokenType.DOT}).endNode();
        selectAlternative.subRecognizer(new SingleSelectRecognizer(), 1, 1).createNode(EShallowEntityType.STATEMENT, "single select").endNode();
        selectAlternative.createNode(EShallowEntityType.STATEMENT, "select block").skipAfter(new ITokenMatcher[]{ETokenType.DOT}).parseUntil(EAbapParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.ENDSELECT, ETokenType.DOT}).endNode();
    }

    @Override
    protected boolean isFilteredToken(IToken token, IToken previousToken) {
        return super.isFilteredToken(token, previousToken) || ETokenType.PRAGMA_DIRECTIVE.matches(token);
    }

    public static enum EAbapParserStates {
        TOPLEVEL,
        IN_TYPE,
        DECLARATIONS,
        STATEMENTS;

    }
}

