/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.cobol;

import eu.cqse.check.framework.scanner.ETokenType;
import java.util.ArrayList;
import java.util.List;

public class ConditionalClause {
    private final List<ETokenType> mandatoryTokens;
    private final ETokenType optionalToken;
    private final boolean optionalTokenStartsClause;

    public ConditionalClause(List<ETokenType> mandatoryTokens, ETokenType optionalToken, boolean optionalTokenStartsClause) {
        this.mandatoryTokens = mandatoryTokens;
        this.optionalToken = optionalToken;
        this.optionalTokenStartsClause = optionalTokenStartsClause;
    }

    public ETokenType[] getClauseTokens(boolean withOptionalToken) {
        return this.getClauseTokensUsingCollection(withOptionalToken, new ArrayList<ETokenType>());
    }

    private ETokenType[] getClauseTokensUsingCollection(boolean withOptionalToken, List<ETokenType> result) {
        int index;
        if (this.optionalTokenStartsClause) {
            result.add(this.optionalToken);
            index = result.size() - 1;
            result.addAll(this.mandatoryTokens);
        } else {
            result.addAll(this.mandatoryTokens);
            result.add(this.optionalToken);
            index = result.size() - 1;
        }
        if (!withOptionalToken) {
            result.remove(index);
        }
        return result.toArray(new ETokenType[0]);
    }

    public ETokenType[] getNegatedClauseTokens(boolean withOptionalToken) {
        ArrayList<ETokenType> result = new ArrayList<ETokenType>();
        result.add(ETokenType.NOT);
        return this.getClauseTokensUsingCollection(withOptionalToken, result);
    }
}

