/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.gosu;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.languages.base.LineBasedStatementRecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.gosu.GosuShallowParser;
import java.util.List;
import java.util.Stack;

class GosuSimpleStatementRecognizer
extends LineBasedStatementRecognizerBase<GosuShallowParser.EGosuParserStates> {
    private static final ITokenMatcher STATEMENT_TERMINATING_TOKEN_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.THROW, ETokenType.RETURN, ETokenType.CONTINUE, ETokenType.BREAK});
    private final EShallowEntityType type;
    private final String subType;

    public GosuSimpleStatementRecognizer(EShallowEntityType type, String subType) {
        this.type = type;
        this.subType = subType;
    }

    @Override
    protected GosuShallowParser.EGosuParserStates getSubParseState() {
        return GosuShallowParser.EGosuParserStates.IN_EXPRESSION;
    }

    @Override
    protected boolean tokenStartsSubParse(IToken token, List<IToken> tokens, int offset, Stack<ETokenType> expectedClosing, int nodeStart) {
        return ETokenType.BACKSLASH.matches(token);
    }

    @Override
    protected boolean startsNewStatement(IToken token, IToken lastToken) {
        if (this.isNestedClosingToken(token.getType())) {
            return true;
        }
        if (lastToken == null) {
            return false;
        }
        if (STATEMENT_TERMINATING_TOKEN_TYPES.matches(token)) {
            return true;
        }
        if (lastToken.getLineNumber() == token.getLineNumber()) {
            return false;
        }
        return !GosuShallowParser.MODIFIERS.or(new ITokenMatcher[]{ETokenType.VAR, ETokenType.ETokenClass.OPERATOR}).matches(lastToken) && !ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.OPERATOR, ETokenType.ETokenClass.DELIMITER}).matches(token);
    }

    @Override
    protected EShallowEntityType getEntityType() {
        return this.type;
    }

    @Override
    protected String getEntitySubtypeName() {
        return this.subType;
    }

    @Override
    protected String getEntityName(List<IToken> tokens, int startOffset) {
        int varIndex;
        if ((this.subType.equals("global variable") || this.subType.equals("local variable")) && (varIndex = TokenStreamUtils.firstTokenMatching(tokens, startOffset, (ITokenMatcher)ETokenType.VAR)) != -1 && varIndex + 1 < tokens.size()) {
            return tokens.get(varIndex + 1).getText();
        }
        if (tokens.get(startOffset).getType() == ETokenType.LPAREN) {
            ++startOffset;
        }
        return super.getEntityName(tokens, startOffset);
    }
}

