/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.iec61131;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;

public class Iec61131ShallowParser
extends ShallowParserBase<EIec61131ParserStates> {
    private static final ITokenMatcher SIMPLE_STATEMENT_KEYWORDS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL, ETokenType.RETURN, ETokenType.EXIT, ETokenType.INTERNAL});
    private static final ITokenMatcher KEYWORDS_CAN_BE_USED_AS_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INTERNAL, ETokenType.CASE});
    private static final ITokenMatcher ALL_POSSIBLE_IDENTIFIERS = SIMPLE_STATEMENT_KEYWORDS.or(new ITokenMatcher[]{KEYWORDS_CAN_BE_USED_AS_IDENTIFIERS});
    private static final ITokenMatcher CASE_LITERALS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL});

    public Iec61131ShallowParser() {
        super(EIec61131ParserStates.class, EIec61131ParserStates.TOP_LEVEL);
        this.createTopLevelRules();
        this.createInVariableRules();
        this.createInTypeDefinitionBlocksRules();
        this.createInMethodRules();
        this.createInSystemVarDeclRules();
    }

    private void createTopLevelRules() {
        this.parseImportSection();
        this.parseAlgorithmBlock();
        this.parseTopLevelVariables();
        this.parseTypeDefinition();
        this.parseSystemObject();
        this.createMethodLikeRule((ITokenMatcher)ETokenType.ALGORITHM, (ITokenMatcher)ETokenType.END_ALGORITHM);
        this.createMethodLikeRule((ITokenMatcher)ETokenType.FUNCTION_BLOCK, (ITokenMatcher)ETokenType.END_FUNCTION_BLOCK);
        this.createMethodLikeRule((ITokenMatcher)ETokenType.ORGANIZATION_BLOCK, (ITokenMatcher)ETokenType.END_ORGANIZATION_BLOCK);
        this.createMethodLikeRule((ITokenMatcher)ETokenType.PROGRAM, (ITokenMatcher)ETokenType.END_PROGRAM);
        this.parseAlgorithmDefinition();
        this.createMethodLikeRule((ITokenMatcher)ETokenType.EVENT_ALGORITHM, (ITokenMatcher)ETokenType.END_ALGORITHM);
        this.createMethodLikeRule((ITokenMatcher)ETokenType.POSTUPDATE_ALGORITHM, (ITokenMatcher)ETokenType.END_ALGORITHM);
        this.parseFunctionDefinition();
        this.createMethodLikeRule((ITokenMatcher)ETokenType.ACTION, (ITokenMatcher)ETokenType.END_ACTION);
        this.parseSystemVariableDeclaration();
    }

    private void parseSystemVariableDeclaration() {
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.SYSTEM_VAR_DECL}).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText()).parseUntil(EIec61131ParserStates.IN_SYSTEM_VAR_DECL).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private void parseFunctionDefinition() {
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FUNCTION, ETokenType.PLAUSIBILITY_FUNCTION}), ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.COLON, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).parseUntil(EIec61131ParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END_FUNCTION}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void parseAlgorithmDefinition() {
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.PROCESS_ALGORITHM, ETokenType.IDENTIFIER, ETokenType.ON, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.AUTOSTART}).parseUntil(EIec61131ParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END_ALGORITHM}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void parseSystemObject() {
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.SYSTEM_OBJECT}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).parseUntil(EIec61131ParserStates.IN_VARS).sequence(new ITokenMatcher[]{ETokenType.END_OBJECT}).endNode();
    }

    private void parseTypeDefinition() {
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.TYPE}).createNode(EShallowEntityType.META, "TYPE").parseUntil(EIec61131ParserStates.IN_TYPES).sequence(new ITokenMatcher[]{ETokenType.END_TYPE}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void parseTopLevelVariables() {
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.TOP_LEVEL}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VAR, ETokenType.SYSTEM_VAR, ETokenType.SYSTEM_VAR_IN, ETokenType.VAR_EXTERNAL, ETokenType.VAR_INPUT, ETokenType.VAR_OUTPUT, ETokenType.VAR_IN_OUT})).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).parseUntil(EIec61131ParserStates.IN_VARS).sequence(new ITokenMatcher[]{ETokenType.END_VAR}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void parseImportSection() {
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORT}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.END_IMPORT}).endNode();
    }

    private void parseAlgorithmBlock() {
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.ALGORITHM_BLOCK, ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.WITH, ETokenType.INTERFACE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.MODULE, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).parseUntil(EIec61131ParserStates.TOP_LEVEL).sequence(new ITokenMatcher[]{ETokenType.END_ALGORITHM_BLOCK}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createMethodLikeRule(ITokenMatcher startTokens, ITokenMatcher endTokens) {
        RecognizerBase commaReferencedVariableRecognizer = this.createRecognizer(base -> base.sequence(new ITokenMatcher[]{ETokenType.COMMA, ETokenType.IDENTIFIER}).skipNested(ETokenType.LBRACK, ETokenType.RBRACK).optional(new ITokenMatcher[]{ETokenType.XOR}));
        RecognizerBase withClause = this.createRecognizer(base -> base.sequence(new ITokenMatcher[]{ETokenType.WITH, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER})}).repeated(new ITokenMatcher[]{ETokenType.DOT, ALL_POSSIBLE_IDENTIFIERS}).skipNested(ETokenType.LBRACK, ETokenType.RBRACK).optional(new ITokenMatcher[]{ETokenType.XOR}).repeatedSubRecognizer(commaReferencedVariableRecognizer));
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.TOP_LEVEL}).sequence(startTokens, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER})).optional(new ITokenMatcher[]{ETokenType.ON, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER})}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).optionalSubRecognizer(withClause).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).parseUntil(EIec61131ParserStates.IN_METHOD).sequence(endTokens).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createInVariableRules() {
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_VARS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.STRUCT}).createNode(EShallowEntityType.ATTRIBUTE, "variable", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.END_STRUCT}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_VARS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).createNode(EShallowEntityType.ATTRIBUTE, "variable", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_VARS}).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.ATTRIBUTE, "empty statement", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createInTypeDefinitionBlocksRules() {
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_TYPES}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.STRUCT}).createNode(EShallowEntityType.ATTRIBUTE, "typedef", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.END_STRUCT}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_TYPES}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).createNode(EShallowEntityType.ATTRIBUTE, "typedef", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createInMethodRules() {
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_METHOD}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VAR, ETokenType.VAR_INPUT, ETokenType.VAR_OUTPUT, ETokenType.VAR_IN_OUT, ETokenType.VAR_EXTERNAL, ETokenType.VAR_GLOBAL, ETokenType.VAR_ACCESS, ETokenType.VAR_TEMP, ETokenType.VAR_CONFIG})).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CONSTANT, ETokenType.RETAIN, ETokenType.NON_RETAIN})).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PROTECTED, ETokenType.PRIVATE, ETokenType.INTERNAL})).parseUntil(EIec61131ParserStates.IN_VARS).sequence(new ITokenMatcher[]{ETokenType.END_VAR}).endNode();
        this.createCaseRule();
        this.createLoopRules();
        this.createIfElseRules();
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_METHOD}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GO_ON_TRANSITION, ETokenType.TRANSITION, ETokenType.EXIT_TRANSITION, ETokenType.GO_ON_EXIT_TRANSITION})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.END_TRANSITION}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.ACTION, ETokenType.IDENTIFIER, ETokenType.COLON}).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).parseUntil(EIec61131ParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END_ACTION}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STEP, ETokenType.INITIAL_STEP}), ETokenType.IDENTIFIER, ETokenType.COLON}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).parseUntil(EIec61131ParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END_STEP}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL})}).createNode(EShallowEntityType.META, "annotation", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"TITLE"})}), ETokenType.EQ}).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.OF})).createNode(EShallowEntityType.META, "annotation", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
        this.createSimpleStatementRules();
    }

    private void createCaseRule() {
        this.inStatementStates().sequence(new ITokenMatcher[]{ETokenType.CASE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.OF}).parseUntil(EIec61131ParserStates.IN_CASE).sequence(new ITokenMatcher[]{ETokenType.END_CASE}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_CASE}).repeated(new ITokenMatcher[]{CASE_LITERALS, ETokenType.COMMA}).sequence(new ITokenMatcher[]{CASE_LITERALS, ETokenType.COLON}).createNode(EShallowEntityType.META, "case label").endNode();
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_CASE}).sequence(new ITokenMatcher[]{ETokenType.ELSE}).createNode(EShallowEntityType.META, "case else").endNode();
    }

    private RecognizerBase<EIec61131ParserStates> inStatementStates() {
        return this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_METHOD, EIec61131ParserStates.IN_CASE});
    }

    private void createLoopRules() {
        this.inStatementStates().sequence(new ITokenMatcher[]{ETokenType.FOR}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DO}).parseUntil(EIec61131ParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END_FOR}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inStatementStates().sequence(new ITokenMatcher[]{ETokenType.WHILE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DO}).parseUntil(EIec61131ParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END_WHILE}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inStatementStates().sequence(new ITokenMatcher[]{ETokenType.REPEAT}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EIec61131ParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.UNTIL}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createIfElseRules() {
        RecognizerBase<EIec61131ParserStates> ifAlternative = this.inStatementStates().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.ELSIF})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.THEN}).parseUntil(EIec61131ParserStates.IN_METHOD);
        ifAlternative.sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.ELSIF})).endNodeWithContinuation(EIec61131ParserStates.IN_METHOD);
        ifAlternative.sequence(new ITokenMatcher[]{ETokenType.END_IF}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.ELSE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EIec61131ParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END_IF}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createSimpleStatementRules() {
        this.inStatementStates().sequence(SIMPLE_STATEMENT_KEYWORDS).repeated(new ITokenMatcher[]{ETokenType.DOT, ALL_POSSIBLE_IDENTIFIERS}).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.ofRange(0, -1)).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inStatementStates().sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
    }

    private void createInSystemVarDeclRules() {
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_SYSTEM_VAR_DECL}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "IEC SV Variable", INameResolver.firstMatchedTokenText()).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.ELEMENT})).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EIec61131ParserStates[]{EIec61131ParserStates.IN_SYSTEM_VAR_DECL}).sequence(new ITokenMatcher[]{ETokenType.ELEMENT}).createNode(EShallowEntityType.ATTRIBUTE, "IEC SV Element").skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.ELEMENT})).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    public static enum EIec61131ParserStates {
        TOP_LEVEL,
        IN_VARS,
        IN_TYPES,
        IN_METHOD,
        IN_CASE,
        IN_SYSTEM_VAR_DECL;

    }
}

