/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.powershell;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.powershell.EPowershellParserState;
import eu.cqse.check.framework.shallowparser.languages.powershell.PowershellSubExpressionRecognizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PowershellShallowParser
extends ShallowParserBase<EPowershellParserState> {
    private static final List<ETokenType> OPENING_PARENTHESES = Arrays.asList(ETokenType.LPAREN, ETokenType.AT_LPAREN, ETokenType.DOLLAR_LPAREN);
    private static final List<ETokenType> CLOSING_PARENTHESES = Arrays.asList(ETokenType.RPAREN, ETokenType.RPAREN, ETokenType.RPAREN);
    private static final ITokenMatcher KEYWORD_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.FOREACH, ETokenType.WHILE, ETokenType.FOR, ETokenType.IF, ETokenType.FUNCTION, ETokenType.SWITCH, ETokenType.CLASS, ETokenType.HIDDEN, ETokenType.STATIC});
    private static final ITokenMatcher STATEMENT_END = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.EOL, ETokenType.RBRACE});
    private static final ITokenMatcher INCLUDING_STATEMENT_END = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.EOL});

    public PowershellShallowParser() {
        super(EPowershellParserState.class, EPowershellParserState.IN_FUNCTION);
        this.createScriptRules();
        this.createFunctionRules();
        this.createFunctionBodyRules();
        this.createMetaRules();
        this.createClassRules();
        this.createEnumRules();
        this.createSwitchRules();
        this.createLambdaRules();
        this.createStatementRules();
    }

    private void createScriptRules() {
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).repeatedSubRecognizer(this.recognizeAnnotation()).sequence(new ITokenMatcher[]{ETokenType.PARAM}).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).createNode(EShallowEntityType.META, "parameter").repeatedSubRecognizer(this.recognizeParameter()).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.RPAREN}).endNode();
    }

    private void createFunctionRules() {
        this.parseParametersAndBody(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).optional(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).sequence(KEYWORD_IDENTIFIERS).createNode(EShallowEntityType.METHOD, "function", INameResolver.previousTokenText()));
        this.parseParametersAndBody(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.FILTER}).optional(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).sequence(KEYWORD_IDENTIFIERS).createNode(EShallowEntityType.METHOD, "filter function", INameResolver.previousTokenText()));
        this.parseParametersAndBody(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.WORKFLOW}).optional(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).sequence(KEYWORD_IDENTIFIERS).createNode(EShallowEntityType.METHOD, "workflow function", INameResolver.previousTokenText()));
    }

    private void parseParametersAndBody(RecognizerBase<EPowershellParserState> functionStart) {
        RecognizerBase<EPowershellParserState> headParams = functionStart.sequence(new ITokenMatcher[]{ETokenType.LPAREN}).repeatedSubRecognizer(this.recognizeParameter()).sequence(new ITokenMatcher[]{ETokenType.RPAREN});
        PowershellShallowParser.endFunction(headParams);
        functionStart.repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).repeated(new ITokenMatcher[]{ETokenType.EOL}).repeatedSubRecognizer(this.recognizeAnnotation()).sequence(new ITokenMatcher[]{ETokenType.PARAM}).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).repeatedSubRecognizer(this.recognizeParameter()).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.RPAREN}).parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        PowershellShallowParser.endFunction(functionStart);
    }

    private static void endFunction(RecognizerBase<EPowershellParserState> recognizer) {
        recognizer.repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private RecognizerBase<EPowershellParserState> recognizeParameter() {
        return this.createRecognizer(start -> start.repeated(new ITokenMatcher[]{ETokenType.EOL}).repeatedSubRecognizer(this.recognizeAnnotation()).sequence(new ITokenMatcher[]{ETokenType.ETokenClass.IDENTIFIER}).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.RPAREN}), OPENING_PARENTHESES, CLOSING_PARENTHESES, (RecognizerBase<EPowershellParserState>)new PowershellSubExpressionRecognizer()).optional(new ITokenMatcher[]{ETokenType.COMMA}).repeated(new ITokenMatcher[]{ETokenType.EOL}));
    }

    private RecognizerBase<EPowershellParserState> recognizeAnnotation() {
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACK}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACK, ETokenType.LBRACK, ETokenType.RBRACK, new PowershellSubExpressionRecognizer()).repeated(new ITokenMatcher[]{ETokenType.EOL}));
    }

    private void createMetaRules() {
        this.createImportRules();
        this.createLabelRules();
    }

    private void createImportRules() {
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.USING, ETokenType.NAMESPACE}).subRecognizer(this.recognizeFullyQualifiedName()).createNode(EShallowEntityType.META, "using namespace", INameResolver.ofRange(2, -1)).sequence(new ITokenMatcher[]{ETokenType.EOL}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.USING, ETokenType.MODULE}).subRecognizer(this.recognizeFullyQualifiedName()).createNode(EShallowEntityType.META, "using module", INameResolver.ofRange(2, -1)).sequence(new ITokenMatcher[]{ETokenType.EOL}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.USING, ETokenType.MODULE, ETokenType.ETokenClass.LITERAL}).createNode(EShallowEntityType.META, "using module", INameResolver.previousTokenText()).sequence(new ITokenMatcher[]{ETokenType.EOL}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.USING, ETokenType.ASSEMBLY, ETokenType.ETokenClass.LITERAL}).createNode(EShallowEntityType.META, "using assembly", INameResolver.previousTokenText()).sequence(new ITokenMatcher[]{ETokenType.EOL}).endNode();
    }

    private void createLabelRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.COLON, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "label", INameResolver.secondMatchedTokenText()).endNode();
    }

    private void createClassRules() {
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.CLASS, KEYWORD_IDENTIFIERS, ETokenType.COLON}).subRecognizer(this.recognizeFullyQualifiedName()).repeated(new ITokenMatcher[]{ETokenType.EOL}).repeatedSubRecognizer(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.COMMA}).repeated(new ITokenMatcher[]{ETokenType.EOL}).subRecognizer(this.recognizeFullyQualifiedName()).repeated(new ITokenMatcher[]{ETokenType.EOL}))).repeated(new ITokenMatcher[]{ETokenType.EOL}).createNode(EShallowEntityType.TYPE, "class", INameResolver.secondMatchedTokenText()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.CLASS, KEYWORD_IDENTIFIERS}).createNode(EShallowEntityType.TYPE, "class", INameResolver.secondMatchedTokenText()).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.INTERFACE, KEYWORD_IDENTIFIERS, ETokenType.COLON}).subRecognizer(this.recognizeFullyQualifiedName()).repeated(new ITokenMatcher[]{ETokenType.EOL}).repeatedSubRecognizer(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.COMMA}).repeated(new ITokenMatcher[]{ETokenType.EOL}).subRecognizer(this.recognizeFullyQualifiedName()).repeated(new ITokenMatcher[]{ETokenType.EOL}))).repeated(new ITokenMatcher[]{ETokenType.EOL}).createNode(EShallowEntityType.TYPE, "interface", INameResolver.secondMatchedTokenText()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.INTERFACE, KEYWORD_IDENTIFIERS}).createNode(EShallowEntityType.TYPE, "interface", INameResolver.secondMatchedTokenText()).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_TYPE}).sequence(KEYWORD_IDENTIFIERS).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).repeatedSubRecognizer(this.recognizeParameter()).sequence(new ITokenMatcher[]{ETokenType.RPAREN}).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.COLON, ETokenType.BASE}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, new PowershellSubExpressionRecognizer()).repeated(new ITokenMatcher[]{ETokenType.EOL}).createNode(EShallowEntityType.METHOD, "constructor", INameResolver.firstMatchedTokenText()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.endMethod(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_TYPE}).sequence(KEYWORD_IDENTIFIERS).preCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LPAREN}))).createNode(EShallowEntityType.METHOD, "constructor", INameResolver.firstMatchedTokenText()));
        this.createClassVariableRules();
        this.createMethodRules();
    }

    private RecognizerBase<EPowershellParserState> recognizeFullyQualifiedName() {
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}));
    }

    private void createClassVariableRules() {
        PowershellShallowParser.endStatement(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_TYPE}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.HIDDEN, ETokenType.STATIC})).repeatedSubRecognizer(this.recognizeAnnotation()).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.HIDDEN, ETokenType.STATIC})).sequence(new ITokenMatcher[]{ETokenType.VARIABLE_IDENTIFIER, ETokenType.EQ}).createNode(EShallowEntityType.ATTRIBUTE, "variable", INameResolver.ofIndex(-2)));
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_TYPE}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.HIDDEN, ETokenType.STATIC})).repeatedSubRecognizer(this.recognizeAnnotation()).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.HIDDEN, ETokenType.STATIC})).sequence(new ITokenMatcher[]{ETokenType.VARIABLE_IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "variable", INameResolver.previousTokenText()).optional(INCLUDING_STATEMENT_END).endNode();
    }

    private void createMethodRules() {
        this.endMethod(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_TYPE}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.HIDDEN, ETokenType.STATIC})).subRecognizer(this.recognizeAnnotation()).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.HIDDEN, ETokenType.STATIC})).sequence(KEYWORD_IDENTIFIERS).createNode(EShallowEntityType.METHOD, "method", INameResolver.previousTokenText()));
    }

    private void endMethod(RecognizerBase<EPowershellParserState> recognizer) {
        recognizer.sequence(new ITokenMatcher[]{ETokenType.LPAREN}).repeatedSubRecognizer(this.recognizeParameter()).sequence(new ITokenMatcher[]{ETokenType.RPAREN}).repeated(new ITokenMatcher[]{ETokenType.EOL}).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createEnumRules() {
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).repeatedSubRecognizer(this.recognizeAnnotation()).sequence(new ITokenMatcher[]{ETokenType.ENUM, KEYWORD_IDENTIFIERS}).createNode(EShallowEntityType.TYPE, "enum", INameResolver.previousTokenText()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_ENUM).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        RecognizerBase enumLiteral = this.inState(new EPowershellParserState[]{EPowershellParserState.IN_ENUM}).sequence(KEYWORD_IDENTIFIERS).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.firstMatchedTokenText());
        enumLiteral.sequence(new ITokenMatcher[]{ETokenType.EQ, ETokenType.INTEGER_LITERAL}).optional(INCLUDING_STATEMENT_END).endNode();
        enumLiteral.optional(INCLUDING_STATEMENT_END).endNode();
    }

    private void createSwitchRules() {
        RecognizerBase switchStart = this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION, EPowershellParserState.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.SWITCH}).createNode(EShallowEntityType.STATEMENT, "switch");
        switchStart.optional(new ITokenMatcher[]{ETokenType.MINUS, ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.MINUS, ETokenType.IDENTIFIER}).subRecognizer(this.recognizeConditions()).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_SWITCH).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        switchStart.skipAfter(new ITokenMatcher[]{ETokenType.MINUS, ETokenType.IDENTIFIER, ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_SWITCH).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        ITokenMatcher caseTypes = ETokenType.ETokenClass.LITERAL.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VARIABLE_IDENTIFIER, ETokenType.IDENTIFIER, ETokenType.DEFAULT})});
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_SWITCH}).sequence(caseTypes).createNode(EShallowEntityType.META, "case", INameResolver.firstMatchedTokenText()).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_SWITCH}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).createNode(EShallowEntityType.META, "case", "lambda expression").skipBeforeWithNesting((ITokenMatcher)ETokenType.RPAREN, OPENING_PARENTHESES, CLOSING_PARENTHESES, new PowershellSubExpressionRecognizer()).sequence(new ITokenMatcher[]{ETokenType.RPAREN}).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_FUNCTION).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_SWITCH}).preCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACE}))).createNode(EShallowEntityType.META, "case", "lambda expression").parseOnce(EPowershellParserState.IN_EXPRESSION).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_FUNCTION).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createLambdaRules() {
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "lambda").parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createFunctionBodyRules() {
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.DYNAMIC_PARAM, ETokenType.LBRACE}).createNode(EShallowEntityType.META, "dynamicparam").parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.BEGIN, ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "begin").parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.PROCESS, ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "process").parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "end").parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.CLEAN, ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "clean").parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createStatementRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
        this.createIfElseRules();
        this.createLoopRules();
        this.createErrorHandlingRules();
        this.createVariableAssigmentRules();
        this.createSimpleStatementRules();
    }

    private void createIfElseRules() {
        RecognizerBase<EPowershellParserState> elseIfRecognizer = this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION, EPowershellParserState.IN_FUNCTION, EPowershellParserState.IN_EXPRESSION}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.ELSE, ETokenType.ELSEIF})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).optionalSubRecognizer(this.recognizeConditions());
        this.endWithPossibleContinuation(elseIfRecognizer.repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), (ITokenMatcher)ETokenType.ELSE);
        this.endWithPossibleContinuation(elseIfRecognizer.repeated(new ITokenMatcher[]{ETokenType.EOL}).parseOnce(EPowershellParserState.IN_FUNCTION), (ITokenMatcher)ETokenType.ELSE);
    }

    private void createLoopRules() {
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION, EPowershellParserState.IN_EXPRESSION}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHILE, ETokenType.FOR, ETokenType.FOREACH})).preCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LPAREN}))).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).subRecognizer(this.recognizeConditions()).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        RecognizerBase<EPowershellParserState> doLoop = this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION, EPowershellParserState.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.DO}).preCondition(this.createRecognizer(start -> start.repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}))).createNode(EShallowEntityType.STATEMENT, "do loop").repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).repeated(new ITokenMatcher[]{ETokenType.EOL});
        doLoop.sequence(new ITokenMatcher[]{ETokenType.WHILE}).subRecognizer(this.recognizeConditions()).endNodeWithName("do while");
        doLoop.sequence(new ITokenMatcher[]{ETokenType.UNTIL}).subRecognizer(this.recognizeConditions()).endNodeWithName("do until");
    }

    private RecognizerBase<EPowershellParserState> recognizeConditions() {
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, OPENING_PARENTHESES, CLOSING_PARENTHESES, new PowershellSubExpressionRecognizer()));
    }

    private void createErrorHandlingRules() {
        this.endWithPossibleContinuation(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.TRY}).createNode(EShallowEntityType.STATEMENT, "try").repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY}));
        this.endWithPossibleContinuation(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.CATCH}).createNode(EShallowEntityType.STATEMENT, "catch").repeated(new ITokenMatcher[]{ETokenType.EOL}).optionalSubRecognizer(this.recognizeCatchErrors()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY}));
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.FINALLY}).createNode(EShallowEntityType.STATEMENT, "finally").repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.TRAP}).createNode(EShallowEntityType.STATEMENT, "trap").repeated(new ITokenMatcher[]{ETokenType.EOL}).optionalSubRecognizer(this.recognizeCatchErrors()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EPowershellParserState.IN_FUNCTION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private RecognizerBase<EPowershellParserState> recognizeCatchErrors() {
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACK}).subRecognizer(this.recognizeFullyQualifiedName()).sequence(new ITokenMatcher[]{ETokenType.RBRACK}).repeated(new ITokenMatcher[]{ETokenType.EOL}).repeatedSubRecognizer(this.createRecognizer(enumeration -> enumeration.sequence(new ITokenMatcher[]{ETokenType.COMMA}).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACK}).subRecognizer(this.recognizeFullyQualifiedName()).sequence(new ITokenMatcher[]{ETokenType.RBRACK}).repeated(new ITokenMatcher[]{ETokenType.EOL}))));
    }

    private void createVariableAssigmentRules() {
        RecognizerBase<EPowershellParserState> assigment = this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION, EPowershellParserState.IN_TYPE}).repeatedSubRecognizer(this.recognizeAnnotation()).sequence(new ITokenMatcher[]{ETokenType.VARIABLE_IDENTIFIER, ETokenType.EQ}).createNode(EShallowEntityType.STATEMENT, "variable", INameResolver.ofIndex(-2));
        PowershellShallowParser.endStatement(assigment);
    }

    private void createSimpleStatementRules() {
        PowershellShallowParser.endStatement(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.CHARACTER_LITERAL, ETokenType.DOUBLE_DOT, ETokenType.CHARACTER_LITERAL}).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.ofRange(0, 2)));
        PowershellShallowParser.endStatement(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).optional(new ITokenMatcher[]{ETokenType.MINUS}).sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL, ETokenType.DOUBLE_DOT}).optional(new ITokenMatcher[]{ETokenType.MINUS}).sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL}).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.ofRange(0, -1)));
        PowershellShallowParser.endStatement(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.RETURN}).createNode(EShallowEntityType.STATEMENT, "return"));
        PowershellShallowParser.endStatement(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.LBRACK}).subRecognizer(this.recognizeFullyQualifiedName()).sequence(new ITokenMatcher[]{ETokenType.RBRACK}).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.ofRange(1, -2)));
        PowershellShallowParser.endStatement(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BREAK, ETokenType.CONTINUE}), ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()));
        PowershellShallowParser.endStatement(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BREAK, ETokenType.CONTINUE, ETokenType.EXIT})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()));
        PowershellShallowParser.endStatement(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(new ITokenMatcher[]{ETokenType.THROW}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()));
        PowershellShallowParser.endStatement(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).sequence(ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.LITERAL})).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.firstMatchedTokenText()));
        PowershellShallowParser.endStatement(this.inState(new EPowershellParserState[]{EPowershellParserState.IN_FUNCTION}).notPreCondition(this.createRecognizer(start -> start.sequence(STATEMENT_END))).createNode(EShallowEntityType.STATEMENT, "simple statement"));
    }

    private static void endStatement(RecognizerBase<EPowershellParserState> recognizer) {
        ArrayList<ETokenType> open = new ArrayList<ETokenType>(OPENING_PARENTHESES);
        open.add(ETokenType.AT_LBRACE);
        ArrayList<ETokenType> close = new ArrayList<ETokenType>(CLOSING_PARENTHESES);
        close.add(ETokenType.RBRACE);
        recognizer.skipBeforeWithNesting(STATEMENT_END, open, close, (RecognizerBase<EPowershellParserState>)new PowershellSubExpressionRecognizer()).optional(INCLUDING_STATEMENT_END).endNode();
    }
}

