/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.util;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class TrivialMethodUtils {
    private static final TokenPattern SIMPLE_GETTER_STATEMENT_PATTERN;
    private static final TokenPattern SIMPLE_SETTER_STATEMENT_PATTERN;
    private static final TokenPattern ABAP_SIMPLE_GETTER_STATEMENT_PATTERN;
    private static final Pattern TYPICAL_GETTER_NAME;
    private static final Set<String> SIMPLE_CS_GETTER;
    private static final Set<String> SIMPLE_CS_SETTER;

    public static boolean isGetterImplementation(ShallowEntity entity) {
        String methodName = entity.getName();
        if (entity.getType() != EShallowEntityType.METHOD || methodName == null) {
            return false;
        }
        ELanguage language = ShallowParsingUtils.getLanguage(entity);
        if (language == ELanguage.ABAP) {
            return TYPICAL_GETTER_NAME.matcher(methodName).lookingAt() && ABAP_SIMPLE_GETTER_STATEMENT_PATTERN.matchFully(TrivialMethodUtils.getSingleChildTokens(entity)) != null;
        }
        if (SIMPLE_GETTER_STATEMENT_PATTERN.matchFully(TrivialMethodUtils.getSingleChildTokens(entity)) == null) {
            return false;
        }
        boolean b = TrivialMethodUtils.isLanguageSpecificGetter(entity);
        if (b) {
            return true;
        }
        if (TYPICAL_GETTER_NAME.matcher(methodName).lookingAt()) {
            return true;
        }
        return TrivialMethodUtils.isPlausibleGetterNameWithoutPrefix(entity, methodName);
    }

    private static boolean isPlausibleGetterNameWithoutPrefix(ShallowEntity entity, String methodName) {
        List<IToken> identifiers = TokenStreamUtils.findAllTokens((List<IToken>)((ShallowEntity)entity.getChildren().getFirst()).includedTokens(), ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.IDENTIFIER}));
        if (identifiers.isEmpty()) {
            return false;
        }
        return TrivialMethodUtils.normalizeName(methodName).equals(TrivialMethodUtils.normalizeName(identifiers.getLast().getText()));
    }

    private static String normalizeName(String name) {
        return name.toLowerCase().replace("_", "");
    }

    static boolean isSetterImplementation(ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.METHOD || entity.getName() == null) {
            return false;
        }
        if (SIMPLE_SETTER_STATEMENT_PATTERN.matchFully(TrivialMethodUtils.getSingleChildTokens(entity)) == null) {
            return false;
        }
        if (TrivialMethodUtils.isLanguageSpecificSetter(entity)) {
            return true;
        }
        return entity.getName().toLowerCase().startsWith("set");
    }

    private static boolean isLanguageSpecificGetter(ShallowEntity entity) {
        ELanguage language;
        ELanguage eLanguage = language = ShallowParsingUtils.getLanguage(entity);
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CS", "JAVASCRIPT"}, (ELanguage)eLanguage, n)) {
            case 0 -> TrivialMethodUtils.isSimpleCSharpGetter(entity);
            case 1 -> {
                if (((IToken)entity.ownStartTokens().getFirst()).getType() == ETokenType.GET) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean isLanguageSpecificSetter(ShallowEntity entity) {
        ELanguage language;
        ELanguage eLanguage = language = ShallowParsingUtils.getLanguage(entity);
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CS", "JAVASCRIPT"}, (ELanguage)eLanguage, n)) {
            case 0 -> TrivialMethodUtils.isSimpleCSharpSetter(entity);
            case 1 -> {
                if (((IToken)entity.ownStartTokens().getFirst()).getType() == ETokenType.SET) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean isSimpleCSharpGetter(ShallowEntity entity) {
        return SIMPLE_CS_GETTER.contains(entity.getSubtype().toLowerCase());
    }

    private static boolean isSimpleCSharpSetter(ShallowEntity entity) {
        return SIMPLE_CS_SETTER.contains(entity.getSubtype().toLowerCase());
    }

    private static List<IToken> getSingleChildTokens(ShallowEntity entity) {
        if (entity.getChildren().size() == 1) {
            return ((ShallowEntity)entity.getChildren().getFirst()).includedTokens();
        }
        return Collections.emptyList();
    }

    private TrivialMethodUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    static {
        SIMPLE_SETTER_STATEMENT_PATTERN = new TokenPattern().optional(ETokenType.THIS, ETokenType.DOT).repeated(ETokenType.IDENTIFIER, ETokenType.DOT).sequence(ETokenType.IDENTIFIER, ETokenType.EQ).alternative(ETokenType.IDENTIFIER, ETokenType.VALUE).optional(EnumSet.of(ETokenType.SEMICOLON, ETokenType.DOT));
        ABAP_SIMPLE_GETTER_STATEMENT_PATTERN = new TokenPattern().sequence(new TokenPattern().alternative(ETokenType.RESULT, ETokenType.IDENTIFIER), ETokenType.EQ, new TokenPattern().alternative(ETokenType.ETokenClass.LITERAL, ETokenType.IDENTIFIER)).optional(ETokenType.DOT);
        TYPICAL_GETTER_NAME = Pattern.compile("([Gg]et|[Ii]s)");
        SIMPLE_CS_GETTER = Set.of("get", "empty get");
        SIMPLE_CS_SETTER = Set.of("set", "empty set", "empty init");
        TokenPattern simpleComparison = new TokenPattern().optional(ETokenType.THIS, ETokenType.DOT).sequence(ETokenType.IDENTIFIER).sequence(ETokenType.ETokenClass.OPERATOR.and(new ITokenMatcher[]{ETokenType.EQ.negated()}), ETokenType.ETokenClass.LITERAL);
        TokenPattern field = new TokenPattern().optional(ETokenType.THIS, ETokenType.DOT).sequence(ETokenType.IDENTIFIER).repeated(ETokenType.DOT, ETokenType.IDENTIFIER);
        SIMPLE_GETTER_STATEMENT_PATTERN = new TokenPattern().optional(new TokenPattern().alternative(ETokenType.RETURN, new TokenPattern().sequence(ETokenType.RESULT, ETokenType.EQ))).alternative(simpleComparison, field, ETokenType.ETokenClass.LITERAL).optional(EnumSet.of(ETokenType.SEMICOLON, ETokenType.DOT));
    }
}

